/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.decryption_verification;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;
import org.bouncycastle.openpgp.PGPLiteralData;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPSignature;
import org.pgpainless.algorithm.CompressionAlgorithm;
import org.pgpainless.algorithm.StreamEncoding;
import org.pgpainless.algorithm.SymmetricKeyAlgorithm;
import org.pgpainless.key.OpenPgpV4Fingerprint;
import org.pgpainless.key.SubkeyIdentifier;
import org.pgpainless.signature.DetachedSignature;
import org.pgpainless.signature.OnePassSignature;

public class OpenPgpMetadata {
    private final Set<Long> recipientKeyIds;
    private final SubkeyIdentifier decryptionKey;
    private final List<OnePassSignature> onePassSignatures;
    private final List<DetachedSignature> detachedSignatures;
    private final SymmetricKeyAlgorithm symmetricKeyAlgorithm;
    private final CompressionAlgorithm compressionAlgorithm;
    private final String fileName;
    private final Date modificationDate;
    private final StreamEncoding fileEncoding;

    public OpenPgpMetadata(Set<Long> recipientKeyIds, SubkeyIdentifier decryptionKey, SymmetricKeyAlgorithm symmetricKeyAlgorithm, CompressionAlgorithm algorithm, List<OnePassSignature> onePassSignatures, List<DetachedSignature> detachedSignatures, String fileName, Date modificationDate, StreamEncoding fileEncoding) {
        this.recipientKeyIds = Collections.unmodifiableSet(recipientKeyIds);
        this.decryptionKey = decryptionKey;
        this.symmetricKeyAlgorithm = symmetricKeyAlgorithm;
        this.compressionAlgorithm = algorithm;
        this.detachedSignatures = Collections.unmodifiableList(detachedSignatures);
        this.onePassSignatures = Collections.unmodifiableList(onePassSignatures);
        this.fileName = fileName;
        this.modificationDate = modificationDate;
        this.fileEncoding = fileEncoding;
    }

    public Set<Long> getRecipientKeyIds() {
        return this.recipientKeyIds;
    }

    public boolean isEncrypted() {
        return this.symmetricKeyAlgorithm != SymmetricKeyAlgorithm.NULL && !this.getRecipientKeyIds().isEmpty();
    }

    public SubkeyIdentifier getDecryptionKey() {
        return this.decryptionKey;
    }

    public SymmetricKeyAlgorithm getSymmetricKeyAlgorithm() {
        return this.symmetricKeyAlgorithm;
    }

    public CompressionAlgorithm getCompressionAlgorithm() {
        return this.compressionAlgorithm;
    }

    public Set<PGPSignature> getSignatures() {
        HashSet<PGPSignature> signatures = new HashSet<PGPSignature>();
        for (DetachedSignature detachedSignature : this.detachedSignatures) {
            signatures.add(detachedSignature.getSignature());
        }
        for (OnePassSignature onePassSignature : this.onePassSignatures) {
            signatures.add(onePassSignature.getSignature());
        }
        return signatures;
    }

    public boolean isSigned() {
        return !this.getSignatures().isEmpty();
    }

    public Map<SubkeyIdentifier, PGPSignature> getVerifiedSignatures() {
        ConcurrentHashMap<SubkeyIdentifier, PGPSignature> verifiedSignatures = new ConcurrentHashMap<SubkeyIdentifier, PGPSignature>();
        for (DetachedSignature detachedSignature : this.detachedSignatures) {
            if (!detachedSignature.isVerified()) continue;
            verifiedSignatures.put(detachedSignature.getSigningKeyIdentifier(), detachedSignature.getSignature());
        }
        for (OnePassSignature onePassSignature : this.onePassSignatures) {
            if (!onePassSignature.isVerified()) continue;
            verifiedSignatures.put(onePassSignature.getSigningKey(), onePassSignature.getSignature());
        }
        return verifiedSignatures;
    }

    public boolean isVerified() {
        return !this.getVerifiedSignatures().isEmpty();
    }

    public boolean containsVerifiedSignatureFrom(PGPPublicKeyRing publicKeys) {
        for (PGPPublicKey key : publicKeys) {
            OpenPgpV4Fingerprint fingerprint = new OpenPgpV4Fingerprint(key);
            if (!this.containsVerifiedSignatureFrom(fingerprint)) continue;
            return true;
        }
        return false;
    }

    public boolean containsVerifiedSignatureFrom(OpenPgpV4Fingerprint fingerprint) {
        for (SubkeyIdentifier verifiedSigningKey : this.getVerifiedSignatures().keySet()) {
            if (!verifiedSigningKey.getPrimaryKeyFingerprint().equals(fingerprint) && !verifiedSigningKey.getSubkeyFingerprint().equals(fingerprint)) continue;
            return true;
        }
        return false;
    }

    @Deprecated
    public FileInfo getFileInfo() {
        return new FileInfo(this.getFileName(), this.getModificationDate(), this.getFileEncoding());
    }

    public String getFileName() {
        return this.fileName;
    }

    public boolean isForYourEyesOnly() {
        return "_CONSOLE".equals(this.getFileName());
    }

    public Date getModificationDate() {
        return this.modificationDate;
    }

    public StreamEncoding getFileEncoding() {
        return this.fileEncoding;
    }

    public static Builder getBuilder() {
        return new Builder();
    }

    public static class Builder {
        private final Set<Long> recipientFingerprints = new HashSet<Long>();
        private SubkeyIdentifier decryptionKey;
        private final List<DetachedSignature> detachedSignatures = new ArrayList<DetachedSignature>();
        private final List<OnePassSignature> onePassSignatures = new ArrayList<OnePassSignature>();
        private SymmetricKeyAlgorithm symmetricKeyAlgorithm = SymmetricKeyAlgorithm.NULL;
        private CompressionAlgorithm compressionAlgorithm = CompressionAlgorithm.UNCOMPRESSED;
        private String fileName;
        private StreamEncoding fileEncoding;
        private Date modificationDate;

        public Builder addRecipientKeyId(Long keyId) {
            this.recipientFingerprints.add(keyId);
            return this;
        }

        public Builder setDecryptionKey(SubkeyIdentifier decryptionKey) {
            this.decryptionKey = decryptionKey;
            return this;
        }

        public Builder setCompressionAlgorithm(CompressionAlgorithm algorithm) {
            this.compressionAlgorithm = algorithm;
            return this;
        }

        public List<DetachedSignature> getDetachedSignatures() {
            return this.detachedSignatures;
        }

        public Builder setSymmetricKeyAlgorithm(SymmetricKeyAlgorithm symmetricKeyAlgorithm) {
            this.symmetricKeyAlgorithm = symmetricKeyAlgorithm;
            return this;
        }

        public Builder setFileName(@Nonnull String fileName) {
            this.fileName = fileName;
            return this;
        }

        public Builder setModificationDate(Date modificationDate) {
            this.modificationDate = modificationDate;
            return this;
        }

        public Builder setFileEncoding(StreamEncoding encoding) {
            this.fileEncoding = encoding;
            return this;
        }

        public void addDetachedSignature(DetachedSignature signature) {
            this.detachedSignatures.add(signature);
        }

        public void addOnePassSignature(OnePassSignature onePassSignature) {
            this.onePassSignatures.add(onePassSignature);
        }

        public OpenPgpMetadata build() {
            return new OpenPgpMetadata(this.recipientFingerprints, this.decryptionKey, this.symmetricKeyAlgorithm, this.compressionAlgorithm, this.onePassSignatures, this.detachedSignatures, this.fileName, this.modificationDate, this.fileEncoding);
        }
    }

    @Deprecated
    public static class FileInfo {
        protected final String fileName;
        protected final Date modificationDate;
        protected final StreamEncoding streamEncoding;

        public FileInfo(String fileName, Date modificationDate, StreamEncoding streamEncoding) {
            this.fileName = fileName == null ? "" : fileName;
            this.modificationDate = modificationDate == null ? PGPLiteralData.NOW : modificationDate;
            this.streamEncoding = streamEncoding;
        }

        public String getFileName() {
            return this.fileName;
        }

        public Date getModificationDate() {
            return this.modificationDate;
        }

        public StreamEncoding getStreamFormat() {
            return this.streamEncoding;
        }

        public boolean equals(Object other) {
            if (other == null) {
                return false;
            }
            if (this == other) {
                return true;
            }
            if (!(other instanceof FileInfo)) {
                return false;
            }
            FileInfo o = (FileInfo)other;
            if (this.getFileName() != null ? !this.getFileName().equals(o.getFileName()) : o.getFileName() != null) {
                return false;
            }
            if (this.getModificationDate() != null) {
                if (o.getModificationDate() == null) {
                    return false;
                }
                long diff = Math.abs(this.getModificationDate().getTime() - o.getModificationDate().getTime());
                if (diff > 1000L) {
                    return false;
                }
            } else if (o.getModificationDate() != null) {
                return false;
            }
            return this.getStreamFormat() == o.getStreamFormat();
        }
    }

    public static class Signature {
        protected final PGPSignature signature;
        protected final OpenPgpV4Fingerprint fingerprint;

        public Signature(PGPSignature signature, OpenPgpV4Fingerprint fingerprint) {
            this.signature = signature;
            this.fingerprint = fingerprint;
        }
    }
}

