/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.encryption_signing;

import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPPrivateKey;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.bouncycastle.openpgp.PGPSecretKeyRingCollection;
import org.bouncycastle.openpgp.PGPSignatureGenerator;
import org.bouncycastle.openpgp.operator.PGPContentSignerBuilder;
import org.pgpainless.PGPainless;
import org.pgpainless.algorithm.DocumentSignatureType;
import org.pgpainless.algorithm.HashAlgorithm;
import org.pgpainless.exception.KeyCannotSignException;
import org.pgpainless.exception.KeyValidationException;
import org.pgpainless.implementation.ImplementationFactory;
import org.pgpainless.key.OpenPgpV4Fingerprint;
import org.pgpainless.key.SubkeyIdentifier;
import org.pgpainless.key.info.KeyRingInfo;
import org.pgpainless.key.protection.SecretKeyRingProtector;
import org.pgpainless.key.protection.UnlockSecretKey;
import org.pgpainless.policy.Policy;

public final class SigningOptions {
    private final Map<SubkeyIdentifier, SigningMethod> signingMethods = new HashMap<SubkeyIdentifier, SigningMethod>();
    private HashAlgorithm hashAlgorithmOverride;

    public static SigningOptions get() {
        return new SigningOptions();
    }

    public SigningOptions addInlineSignatures(SecretKeyRingProtector secrectKeyDecryptor, PGPSecretKeyRingCollection signingKeys, DocumentSignatureType signatureType) throws KeyValidationException, PGPException {
        for (PGPSecretKeyRing signingKey : signingKeys) {
            this.addInlineSignature(secrectKeyDecryptor, signingKey, signatureType);
        }
        return this;
    }

    public SigningOptions addInlineSignature(SecretKeyRingProtector secretKeyDecryptor, PGPSecretKeyRing secretKey, DocumentSignatureType signatureType) throws KeyValidationException, PGPException {
        return this.addInlineSignature(secretKeyDecryptor, secretKey, null, signatureType);
    }

    public SigningOptions addInlineSignature(SecretKeyRingProtector secretKeyDecryptor, PGPSecretKeyRing secretKey, String userId, DocumentSignatureType signatureType) throws KeyValidationException, PGPException {
        KeyRingInfo keyRingInfo = new KeyRingInfo(secretKey, new Date());
        if (userId != null && !keyRingInfo.isUserIdValid(userId)) {
            throw new KeyValidationException(userId, keyRingInfo.getLatestUserIdCertification(userId), keyRingInfo.getUserIdRevocation(userId));
        }
        List<PGPPublicKey> signingPubKeys = keyRingInfo.getSigningSubkeys();
        if (signingPubKeys.isEmpty()) {
            throw new KeyCannotSignException("Key " + new OpenPgpV4Fingerprint(secretKey) + " has no valid signing key.");
        }
        for (PGPPublicKey signingPubKey : signingPubKeys) {
            PGPSecretKey signingSecKey = secretKey.getSecretKey(signingPubKey.getKeyID());
            PGPPrivateKey signingSubkey = UnlockSecretKey.unlockSecretKey(signingSecKey, secretKeyDecryptor);
            Set<HashAlgorithm> hashAlgorithms = keyRingInfo.getPreferredHashAlgorithms(userId, signingPubKey.getKeyID());
            HashAlgorithm hashAlgorithm = this.negotiateHashAlgorithm(hashAlgorithms, PGPainless.getPolicy());
            this.addSigningMethod(secretKey, signingSubkey, hashAlgorithm, signatureType, false);
        }
        return this;
    }

    public SigningOptions addDetachedSignatures(SecretKeyRingProtector secretKeyDecryptor, PGPSecretKeyRingCollection signingKeys, DocumentSignatureType signatureType) throws PGPException {
        for (PGPSecretKeyRing signingKey : signingKeys) {
            this.addDetachedSignature(secretKeyDecryptor, signingKey, signatureType);
        }
        return this;
    }

    public SigningOptions addDetachedSignature(SecretKeyRingProtector secretKeyDecryptor, PGPSecretKeyRing secretKey, DocumentSignatureType signatureType) throws PGPException {
        return this.addDetachedSignature(secretKeyDecryptor, secretKey, null, signatureType);
    }

    public SigningOptions addDetachedSignature(SecretKeyRingProtector secretKeyDecryptor, PGPSecretKeyRing secretKey, String userId, DocumentSignatureType signatureType) throws PGPException {
        KeyRingInfo keyRingInfo = new KeyRingInfo(secretKey, new Date());
        if (userId != null && !keyRingInfo.isUserIdValid(userId)) {
            throw new KeyValidationException(userId, keyRingInfo.getLatestUserIdCertification(userId), keyRingInfo.getUserIdRevocation(userId));
        }
        List<PGPPublicKey> signingPubKeys = keyRingInfo.getSigningSubkeys();
        if (signingPubKeys.isEmpty()) {
            throw new KeyCannotSignException("Key has no valid signing key.");
        }
        for (PGPPublicKey signingPubKey : signingPubKeys) {
            PGPSecretKey signingSecKey = secretKey.getSecretKey(signingPubKey.getKeyID());
            PGPPrivateKey signingSubkey = signingSecKey.extractPrivateKey(secretKeyDecryptor.getDecryptor(signingPubKey.getKeyID()));
            Set<HashAlgorithm> hashAlgorithms = keyRingInfo.getPreferredHashAlgorithms(userId, signingPubKey.getKeyID());
            HashAlgorithm hashAlgorithm = this.negotiateHashAlgorithm(hashAlgorithms, PGPainless.getPolicy());
            this.addSigningMethod(secretKey, signingSubkey, hashAlgorithm, signatureType, true);
        }
        return this;
    }

    private void addSigningMethod(PGPSecretKeyRing secretKey, PGPPrivateKey signingSubkey, HashAlgorithm hashAlgorithm, DocumentSignatureType signatureType, boolean detached) throws PGPException {
        SubkeyIdentifier signingKeyIdentifier = new SubkeyIdentifier(secretKey, signingSubkey.getKeyID());
        PGPSignatureGenerator generator = this.createSignatureGenerator(signingSubkey, hashAlgorithm, signatureType);
        SigningMethod signingMethod = detached ? SigningMethod.detachedSignature(generator) : SigningMethod.inlineSignature(generator);
        this.signingMethods.put(signingKeyIdentifier, signingMethod);
    }

    private HashAlgorithm negotiateHashAlgorithm(Set<HashAlgorithm> preferences, Policy policy) {
        if (this.hashAlgorithmOverride != null) {
            return this.hashAlgorithmOverride;
        }
        HashAlgorithm algorithm = policy.getSignatureHashAlgorithmPolicy().defaultHashAlgorithm();
        if (preferences.isEmpty()) {
            return algorithm;
        }
        for (HashAlgorithm pref : preferences) {
            if (!policy.getSignatureHashAlgorithmPolicy().isAcceptable(pref)) continue;
            return pref;
        }
        return algorithm;
    }

    private PGPSignatureGenerator createSignatureGenerator(PGPPrivateKey privateKey, HashAlgorithm hashAlgorithm, DocumentSignatureType signatureType) throws PGPException {
        int publicKeyAlgorithm = privateKey.getPublicKeyPacket().getAlgorithm();
        PGPContentSignerBuilder signerBuilder = ImplementationFactory.getInstance().getPGPContentSignerBuilder(publicKeyAlgorithm, hashAlgorithm.getAlgorithmId());
        PGPSignatureGenerator signatureGenerator = new PGPSignatureGenerator(signerBuilder);
        signatureGenerator.init(signatureType.getSignatureType().getCode(), privateKey);
        return signatureGenerator;
    }

    public Map<SubkeyIdentifier, SigningMethod> getSigningMethods() {
        return Collections.unmodifiableMap(this.signingMethods);
    }

    public SigningOptions overrideHashAlgorithm(HashAlgorithm hashAlgorithmOverride) {
        this.hashAlgorithmOverride = hashAlgorithmOverride;
        return this;
    }

    public HashAlgorithm getHashAlgorithmOverride() {
        return this.hashAlgorithmOverride;
    }

    public static final class SigningMethod {
        private final PGPSignatureGenerator signatureGenerator;
        private final boolean detached;

        private SigningMethod(PGPSignatureGenerator signatureGenerator, boolean detached) {
            this.signatureGenerator = signatureGenerator;
            this.detached = detached;
        }

        public static SigningMethod inlineSignature(PGPSignatureGenerator signatureGenerator) {
            return new SigningMethod(signatureGenerator, false);
        }

        public static SigningMethod detachedSignature(PGPSignatureGenerator signatureGenerator) {
            return new SigningMethod(signatureGenerator, true);
        }

        public boolean isDetached() {
            return this.detached;
        }

        public PGPSignatureGenerator getSignatureGenerator() {
            return this.signatureGenerator;
        }
    }
}

