/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.key.protection;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPKeyRing;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.operator.PBESecretKeyDecryptor;
import org.bouncycastle.openpgp.operator.PBESecretKeyEncryptor;
import org.pgpainless.key.OpenPgpV4Fingerprint;
import org.pgpainless.key.protection.KeyRingProtectionSettings;
import org.pgpainless.key.protection.PasswordBasedSecretKeyRingProtector;
import org.pgpainless.key.protection.SecretKeyRingProtector;
import org.pgpainless.key.protection.passphrase_provider.SecretKeyPassphraseProvider;
import org.pgpainless.util.Passphrase;

public class CachingSecretKeyRingProtector
implements SecretKeyRingProtector,
SecretKeyPassphraseProvider {
    private final Map<Long, Passphrase> cache = new HashMap<Long, Passphrase>();
    private final SecretKeyRingProtector protector;
    private final SecretKeyPassphraseProvider provider;

    public CachingSecretKeyRingProtector(@Nonnull Map<Long, Passphrase> passphrases, @Nonnull KeyRingProtectionSettings protectionSettings, @Nullable SecretKeyPassphraseProvider missingPassphraseCallback) {
        this.cache.putAll(passphrases);
        this.protector = new PasswordBasedSecretKeyRingProtector(protectionSettings, this);
        this.provider = missingPassphraseCallback;
    }

    public void addPassphrase(@Nonnull Long keyId, @Nullable Passphrase passphrase) {
        this.cache.put(keyId, passphrase);
    }

    public void addPassphrase(@Nonnull PGPKeyRing keyRing, @Nullable Passphrase passphrase) {
        Iterator<PGPPublicKey> keys = keyRing.getPublicKeys();
        while (keys.hasNext()) {
            PGPPublicKey publicKey = keys.next();
            this.addPassphrase(publicKey, passphrase);
        }
    }

    public void addPassphrase(@Nonnull PGPPublicKey key, @Nullable Passphrase passphrase) {
        this.addPassphrase(key.getKeyID(), passphrase);
    }

    public void addPassphrase(@Nonnull OpenPgpV4Fingerprint fingerprint, @Nullable Passphrase passphrase) {
        this.addPassphrase(fingerprint.getKeyId(), passphrase);
    }

    public void forgetPassphrase(@Nonnull Long keyId) {
        Passphrase passphrase = this.cache.get(keyId);
        passphrase.clear();
        this.cache.remove(keyId);
    }

    public void forgetPassphrase(@Nonnull PGPKeyRing keyRing) {
        Iterator<PGPPublicKey> keys = keyRing.getPublicKeys();
        while (keys.hasNext()) {
            PGPPublicKey publicKey = keys.next();
            this.forgetPassphrase(publicKey);
        }
    }

    public void forgetPassphrase(@Nonnull PGPPublicKey key) {
        this.forgetPassphrase(key.getKeyID());
    }

    @Override
    @Nullable
    public Passphrase getPassphraseFor(Long keyId) {
        Passphrase passphrase = this.cache.get(keyId);
        if (passphrase == null || !passphrase.isValid()) {
            if (this.provider == null) {
                return null;
            }
            passphrase = this.provider.getPassphraseFor(keyId);
            if (passphrase != null) {
                this.cache.put(keyId, passphrase);
            }
        }
        return passphrase;
    }

    @Override
    @Nullable
    public PBESecretKeyDecryptor getDecryptor(@Nonnull Long keyId) throws PGPException {
        return this.protector.getDecryptor(keyId);
    }

    @Override
    @Nullable
    public PBESecretKeyEncryptor getEncryptor(@Nonnull Long keyId) throws PGPException {
        return this.protector.getEncryptor(keyId);
    }
}

