/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.sop;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PushbackInputStream;
import java.nio.charset.Charset;
import java.util.Arrays;
import org.bouncycastle.bcpg.ArmoredOutputStream;
import org.pgpainless.util.ArmoredOutputStreamFactory;
import org.pgpainless.util.StreamUtil;
import sop.Ready;
import sop.enums.ArmorLabel;
import sop.exception.SOPGPException;
import sop.operation.Armor;

public class ArmorImpl
implements Armor {
    public static final byte[] ARMOR_START = "-----BEGIN PGP".getBytes(Charset.forName("UTF8"));
    boolean allowNested = false;

    @Override
    public Armor label(ArmorLabel label) throws SOPGPException.UnsupportedOption {
        throw new SOPGPException.UnsupportedOption();
    }

    @Override
    public Armor allowNested() throws SOPGPException.UnsupportedOption {
        this.allowNested = true;
        return this;
    }

    @Override
    public Ready data(final InputStream data) throws SOPGPException.BadData {
        return new Ready(){

            @Override
            public void writeTo(OutputStream outputStream) throws IOException {
                PushbackInputStream pbIn = new PushbackInputStream(data, ARMOR_START.length);
                byte[] buffer = new byte[ARMOR_START.length];
                int read = pbIn.read(buffer);
                pbIn.unread(buffer, 0, read);
                if (!ArmorImpl.this.allowNested && Arrays.equals(ARMOR_START, buffer)) {
                    StreamUtil.pipeAll(pbIn, System.out);
                } else {
                    ArmoredOutputStream armor = ArmoredOutputStreamFactory.get(System.out);
                    StreamUtil.pipeAll(pbIn, armor);
                    armor.close();
                }
            }
        };
    }
}

