/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.util;

import java.util.Arrays;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class Passphrase {
    private final Object lock = new Object();
    private final char[] chars;
    private boolean valid = true;

    public Passphrase(@Nullable char[] chars) {
        char[] trimmed;
        this.chars = (char[])(chars == null ? null : (char[])((trimmed = Passphrase.removeTrailingAndLeadingWhitespace(chars)).length == 0 ? null : trimmed));
    }

    private static char[] removeTrailingAndLeadingWhitespace(char[] chars) {
        int j;
        int i;
        for (i = 0; i < chars.length && Passphrase.isWhitespace(chars[i]); ++i) {
        }
        for (j = chars.length - 1; j >= i && Passphrase.isWhitespace(chars[j]); --j) {
        }
        char[] trimmed = new char[chars.length - i - (chars.length - 1 - j)];
        System.arraycopy(chars, i, trimmed, 0, trimmed.length);
        return trimmed;
    }

    private static boolean isWhitespace(char xar) {
        return xar == ' ' || xar == '\n' || xar == '\t';
    }

    public static Passphrase fromPassword(@Nonnull String password) {
        return new Passphrase(password.toCharArray());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Object object = this.lock;
        synchronized (object) {
            if (this.chars != null) {
                Arrays.fill(this.chars, ' ');
            }
            this.valid = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public char[] getChars() {
        Object object = this.lock;
        synchronized (object) {
            if (!this.valid) {
                throw new IllegalStateException("Passphrase has been cleared.");
            }
            if (this.chars == null) {
                return null;
            }
            char[] copy = new char[this.chars.length];
            System.arraycopy(this.chars, 0, copy, 0, this.chars.length);
            return copy;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isValid() {
        Object object = this.lock;
        synchronized (object) {
            return this.valid;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty() {
        Object object = this.lock;
        synchronized (object) {
            return this.valid && this.chars == null;
        }
    }

    public static Passphrase emptyPassphrase() {
        return new Passphrase(null);
    }

    public int hashCode() {
        if (this.getChars() == null) {
            return 0;
        }
        return new String(this.getChars()).hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Passphrase)) {
            return false;
        }
        Passphrase other = (Passphrase)obj;
        return Arrays.equals(this.getChars(), other.getChars());
    }
}

