/*
 * Decompiled with CFR 0.152.
 */
package sop.cli.picocli.commands;

import java.io.IOException;
import picocli.CommandLine;
import sop.Ready;
import sop.cli.picocli.Print;
import sop.cli.picocli.SopCLI;
import sop.exception.SOPGPException;
import sop.operation.ExtractCert;

@CommandLine.Command(name="extract-cert", description={"Extract a public key certificate from a secret key from standard input"}, exitCodeOnInvalidInput=37)
public class ExtractCertCmd
implements Runnable {
    @CommandLine.Option(names={"--no-armor"}, description={"ASCII armor the output"}, negatable=true)
    boolean armor = true;

    @Override
    public void run() {
        ExtractCert extractCert = SopCLI.getSop().extractCert();
        if (!this.armor) {
            extractCert.noArmor();
        }
        try {
            Ready ready = extractCert.key(System.in);
            ready.writeTo(System.out);
        }
        catch (IOException e) {
            Print.errln("IO Error.");
            Print.trace(e);
            System.exit(1);
        }
        catch (SOPGPException.BadData badData) {
            Print.errln("Standard Input does not contain valid OpenPGP private key material.");
            Print.trace(badData);
            System.exit(badData.getExitCode());
        }
    }
}

