/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.key.info;

import java.util.Set;
import javax.annotation.Nonnull;
import org.bouncycastle.openpgp.PGPSignature;
import org.pgpainless.algorithm.CompressionAlgorithm;
import org.pgpainless.algorithm.HashAlgorithm;
import org.pgpainless.algorithm.SymmetricKeyAlgorithm;
import org.pgpainless.key.SubkeyIdentifier;
import org.pgpainless.key.info.KeyRingInfo;
import org.pgpainless.signature.subpackets.SignatureSubpacketsUtil;

public abstract class KeyAccessor {
    protected final KeyRingInfo info;
    protected final SubkeyIdentifier key;

    public KeyAccessor(KeyRingInfo info, SubkeyIdentifier key) {
        this.info = info;
        this.key = key;
    }

    @Nonnull
    public abstract PGPSignature getSignatureWithPreferences();

    public Set<SymmetricKeyAlgorithm> getPreferredSymmetricKeyAlgorithms() {
        return SignatureSubpacketsUtil.parsePreferredSymmetricKeyAlgorithms(this.getSignatureWithPreferences());
    }

    public Set<HashAlgorithm> getPreferredHashAlgorithms() {
        return SignatureSubpacketsUtil.parsePreferredHashAlgorithms(this.getSignatureWithPreferences());
    }

    public Set<CompressionAlgorithm> getPreferredCompressionAlgorithms() {
        return SignatureSubpacketsUtil.parsePreferredCompressionAlgorithms(this.getSignatureWithPreferences());
    }

    public static class ViaKeyId
    extends KeyAccessor {
        public ViaKeyId(KeyRingInfo info, SubkeyIdentifier key) {
            super(info, key);
        }

        @Override
        @Nonnull
        public PGPSignature getSignatureWithPreferences() {
            PGPSignature signature = this.info.getLatestDirectKeySelfSignature();
            if (signature != null) {
                return signature;
            }
            signature = this.info.getLatestUserIdCertification(this.info.getPrimaryUserId());
            if (signature == null) {
                throw new IllegalStateException("No valid signature found.");
            }
            return signature;
        }
    }

    public static class ViaUserId
    extends KeyAccessor {
        private final String userId;

        public ViaUserId(KeyRingInfo info, SubkeyIdentifier key, String userId) {
            super(info, key);
            this.userId = userId;
        }

        @Override
        @Nonnull
        public PGPSignature getSignatureWithPreferences() {
            PGPSignature signature = this.info.getLatestUserIdCertification(this.userId);
            if (signature != null) {
                return signature;
            }
            throw new IllegalStateException("No valid user-id certification signature found for '" + this.userId + "'.");
        }
    }
}

