/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.util;

import java.io.IOException;
import java.io.InputStream;
import org.bouncycastle.bcpg.ArmoredInputStream;

public class CRCingArmoredInputStreamWrapper
extends ArmoredInputStream {
    private final ArmoredInputStream inputStream;

    public CRCingArmoredInputStreamWrapper(ArmoredInputStream inputStream) throws IOException {
        super(inputStream, false);
        this.inputStream = inputStream;
    }

    public static InputStream possiblyWrap(InputStream inputStream) throws IOException {
        if (inputStream instanceof CRCingArmoredInputStreamWrapper) {
            return inputStream;
        }
        if (inputStream instanceof ArmoredInputStream) {
            return new CRCingArmoredInputStreamWrapper((ArmoredInputStream)inputStream);
        }
        return inputStream;
    }

    @Override
    public boolean isClearText() {
        return this.inputStream.isClearText();
    }

    @Override
    public boolean isEndOfStream() {
        return this.inputStream.isEndOfStream();
    }

    @Override
    public String getArmorHeaderLine() {
        return this.inputStream.getArmorHeaderLine();
    }

    @Override
    public String[] getArmorHeaders() {
        return this.inputStream.getArmorHeaders();
    }

    @Override
    public int read() throws IOException {
        return this.inputStream.read();
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int i;
        this.checkIndexSize(b.length, off, len);
        if (len == 0) {
            return 0;
        }
        int c = this.read();
        if (c == -1) {
            return -1;
        }
        b[off] = (byte)c;
        for (i = 1; i < len && (c = this.read()) != -1; ++i) {
            b[off + i] = (byte)c;
        }
        return i;
    }

    private void checkIndexSize(int size, int off, int len) {
        if (off < 0 || len < 0) {
            throw new IndexOutOfBoundsException("Offset and length cannot be negative.");
        }
        if (size < off + len) {
            throw new IndexOutOfBoundsException("Invalid offset and length.");
        }
    }

    @Override
    public long skip(long n) throws IOException {
        return this.inputStream.skip(n);
    }

    @Override
    public int available() throws IOException {
        return this.inputStream.available();
    }

    @Override
    public void close() throws IOException {
        this.inputStream.close();
    }

    @Override
    public synchronized void mark(int readlimit) {
        this.inputStream.mark(readlimit);
    }

    @Override
    public synchronized void reset() throws IOException {
        this.inputStream.reset();
    }

    @Override
    public boolean markSupported() {
        return this.inputStream.markSupported();
    }
}

