/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.util.selection.userid;

import java.util.ArrayList;
import java.util.List;
import org.bouncycastle.openpgp.PGPKeyRing;
import org.pgpainless.PGPainless;

public abstract class SelectUserId {
    protected abstract boolean accept(String var1);

    public List<String> selectUserIds(PGPKeyRing keyRing) {
        List<String> userIds = PGPainless.inspectKeyRing(keyRing).getValidUserIds();
        return this.selectUserIds(userIds);
    }

    public List<String> selectUserIds(List<String> userIds) {
        ArrayList<String> selected = new ArrayList<String>();
        for (String userId : userIds) {
            if (!this.accept(userId)) continue;
            selected.add(userId);
        }
        return selected;
    }

    public String firstMatch(PGPKeyRing keyRing) {
        return this.firstMatch(this.selectUserIds(keyRing));
    }

    public String firstMatch(List<String> userIds) {
        for (String userId : userIds) {
            if (!this.accept(userId)) continue;
            return userId;
        }
        return null;
    }

    public static SelectUserId containsSubstring(final String query) {
        return new SelectUserId(){

            @Override
            protected boolean accept(String userId) {
                return userId.contains(query);
            }
        };
    }

    public static SelectUserId exactMatch(final String query) {
        return new SelectUserId(){

            @Override
            protected boolean accept(String userId) {
                return userId.equals(query);
            }
        };
    }

    public static SelectUserId startsWith(final String substring) {
        return new SelectUserId(){

            @Override
            protected boolean accept(String userId) {
                return userId.startsWith(substring);
            }
        };
    }

    public static SelectUserId containsEmailAddress(String email) {
        return SelectUserId.containsSubstring(email.matches("^<.+>$") ? email : '<' + email + '>');
    }

    public static SelectUserId validUserId(final PGPKeyRing keyRing) {
        return new SelectUserId(){

            @Override
            protected boolean accept(String userId) {
                return PGPainless.inspectKeyRing(keyRing).isUserIdValid(userId);
            }
        };
    }

    public static SelectUserId and(final SelectUserId ... strategies) {
        return new SelectUserId(){

            @Override
            protected boolean accept(String userId) {
                boolean accept = true;
                for (SelectUserId strategy : strategies) {
                    accept &= strategy.accept(userId);
                }
                return accept;
            }
        };
    }

    public static SelectUserId or(final SelectUserId ... strategies) {
        return new SelectUserId(){

            @Override
            protected boolean accept(String userId) {
                boolean accept = false;
                for (SelectUserId strategy : strategies) {
                    accept |= strategy.accept(userId);
                }
                return accept;
            }
        };
    }

    public static SelectUserId not(final SelectUserId strategy) {
        return new SelectUserId(){

            @Override
            protected boolean accept(String userId) {
                return !strategy.accept(userId);
            }
        };
    }
}

