/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.key.info;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.bouncycastle.bcpg.sig.PrimaryUserID;
import org.bouncycastle.openpgp.PGPKeyRing;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.bouncycastle.openpgp.PGPSignature;
import org.pgpainless.PGPainless;
import org.pgpainless.algorithm.CompressionAlgorithm;
import org.pgpainless.algorithm.EncryptionPurpose;
import org.pgpainless.algorithm.HashAlgorithm;
import org.pgpainless.algorithm.KeyFlag;
import org.pgpainless.algorithm.PublicKeyAlgorithm;
import org.pgpainless.algorithm.SymmetricKeyAlgorithm;
import org.pgpainless.exception.KeyValidationError;
import org.pgpainless.key.OpenPgpFingerprint;
import org.pgpainless.key.SubkeyIdentifier;
import org.pgpainless.key.info.KeyAccessor;
import org.pgpainless.key.info.KeyInfo;
import org.pgpainless.policy.Policy;
import org.pgpainless.signature.SignaturePicker;
import org.pgpainless.signature.SignatureUtils;
import org.pgpainless.signature.subpackets.SignatureSubpacketsUtil;
import org.pgpainless.util.CollectionUtils;

public class KeyRingInfo {
    private static final Pattern PATTERN_EMAIL = Pattern.compile("[A-Z0-9a-z._%+-]+@[A-Za-z0-9.-]+\\.[A-Za-z]{2,6}");
    private final PGPKeyRing keys;
    private Signatures signatures;

    public static KeyRingInfo evaluateForSignature(PGPKeyRing keyRing, PGPSignature signature) {
        return new KeyRingInfo(keyRing, signature.getCreationTime());
    }

    public KeyRingInfo(PGPKeyRing keys) {
        this(keys, new Date());
    }

    public KeyRingInfo(PGPKeyRing keys, Date validationDate) {
        this.keys = keys;
        this.signatures = new Signatures(keys, validationDate, PGPainless.getPolicy());
    }

    public PGPPublicKey getPublicKey() {
        return this.keys.getPublicKey();
    }

    @Nullable
    public PGPPublicKey getPublicKey(OpenPgpFingerprint fingerprint) {
        return this.getPublicKey(fingerprint.getKeyId());
    }

    @Nullable
    public PGPPublicKey getPublicKey(long keyId) {
        return KeyRingInfo.getPublicKey(this.keys, keyId);
    }

    @Nullable
    public static PGPPublicKey getPublicKey(PGPKeyRing keyRing, long keyId) {
        return keyRing.getPublicKey(keyId);
    }

    public boolean isKeyValidlyBound(long keyId) {
        PGPPublicKey publicKey = this.keys.getPublicKey(keyId);
        if (publicKey == null) {
            return false;
        }
        if (publicKey == this.getPublicKey()) {
            if (this.signatures.primaryKeyRevocation != null && SignatureUtils.isHardRevocation(this.signatures.primaryKeyRevocation)) {
                return false;
            }
            return this.signatures.primaryKeyRevocation == null;
        }
        PGPSignature binding = (PGPSignature)this.signatures.subkeyBindings.get(keyId);
        PGPSignature revocation = (PGPSignature)this.signatures.subkeyRevocations.get(keyId);
        if (binding == null || SignatureUtils.isSignatureExpired(binding)) {
            return false;
        }
        if (revocation != null) {
            if (SignatureUtils.isHardRevocation(revocation)) {
                return false;
            }
            if (!SignatureUtils.isSignatureExpired(revocation) && revocation.getCreationTime().after(binding.getCreationTime())) {
                return false;
            }
        }
        return true;
    }

    public List<PGPPublicKey> getPublicKeys() {
        Iterator<PGPPublicKey> iterator = this.keys.getPublicKeys();
        List<PGPPublicKey> list = CollectionUtils.iteratorToList(iterator);
        return Collections.unmodifiableList(list);
    }

    @Nullable
    public PGPSecretKey getSecretKey() {
        if (this.keys instanceof PGPSecretKeyRing) {
            PGPSecretKeyRing secretKeys = (PGPSecretKeyRing)this.keys;
            return secretKeys.getSecretKey();
        }
        return null;
    }

    @Nullable
    public PGPSecretKey getSecretKey(OpenPgpFingerprint fingerprint) {
        return this.getSecretKey(fingerprint.getKeyId());
    }

    @Nullable
    public PGPSecretKey getSecretKey(long keyId) {
        if (this.keys instanceof PGPSecretKeyRing) {
            return ((PGPSecretKeyRing)this.keys).getSecretKey(keyId);
        }
        return null;
    }

    public List<PGPSecretKey> getSecretKeys() {
        if (this.keys instanceof PGPSecretKeyRing) {
            PGPSecretKeyRing secretKeys = (PGPSecretKeyRing)this.keys;
            Iterator<PGPSecretKey> iterator = secretKeys.getSecretKeys();
            return Collections.unmodifiableList(CollectionUtils.iteratorToList(iterator));
        }
        return Collections.emptyList();
    }

    public long getKeyId() {
        return this.getPublicKey().getKeyID();
    }

    public OpenPgpFingerprint getFingerprint() {
        return OpenPgpFingerprint.of(this.getPublicKey());
    }

    @Nullable
    public String getPrimaryUserId() {
        String primaryUserId = null;
        Date modificationDate = null;
        List<String> validUserIds = this.getValidUserIds();
        if (validUserIds.isEmpty()) {
            return null;
        }
        for (String userId : validUserIds) {
            PrimaryUserID subpacket;
            PGPSignature signature = (PGPSignature)this.signatures.userIdCertifications.get(userId);
            if (signature == null || (subpacket = SignatureSubpacketsUtil.getPrimaryUserId(signature)) == null || !subpacket.isPrimaryUserID() || modificationDate != null && !modificationDate.before(signature.getCreationTime())) continue;
            primaryUserId = userId;
            modificationDate = signature.getCreationTime();
        }
        if (primaryUserId == null) {
            return validUserIds.get(0);
        }
        return primaryUserId;
    }

    public List<String> getUserIds() {
        Iterator<String> iterator = this.getPublicKey().getUserIDs();
        List<String> userIds = CollectionUtils.iteratorToList(iterator);
        return userIds;
    }

    public List<String> getValidUserIds() {
        ArrayList<String> valid = new ArrayList<String>();
        List<String> userIds = this.getUserIds();
        for (String userId : userIds) {
            if (!this.isUserIdValid(userId)) continue;
            valid.add(userId);
        }
        return valid;
    }

    public boolean isUserIdValid(String userId) {
        PGPSignature certification = (PGPSignature)this.signatures.userIdCertifications.get(userId);
        PGPSignature revocation = (PGPSignature)this.signatures.userIdRevocations.get(userId);
        if (certification == null) {
            return false;
        }
        if (SignatureUtils.isSignatureExpired(certification)) {
            return false;
        }
        if (revocation == null) {
            return true;
        }
        if (SignatureUtils.isHardRevocation(revocation)) {
            return false;
        }
        return certification.getCreationTime().after(revocation.getCreationTime());
    }

    public List<String> getEmailAddresses() {
        List<String> userIds = this.getUserIds();
        ArrayList<String> emails = new ArrayList<String>();
        for (String userId : userIds) {
            Matcher matcher = PATTERN_EMAIL.matcher(userId);
            if (!matcher.find()) continue;
            emails.add(matcher.group());
        }
        return emails;
    }

    @Nullable
    public PGPSignature getLatestDirectKeySelfSignature() {
        return this.signatures.primaryKeySelfSignature;
    }

    @Nullable
    public PGPSignature getRevocationSelfSignature() {
        return this.signatures.primaryKeyRevocation;
    }

    @Nullable
    public PGPSignature getLatestUserIdCertification(String userId) {
        return (PGPSignature)this.signatures.userIdCertifications.get(userId);
    }

    @Nullable
    public PGPSignature getUserIdRevocation(String userId) {
        return (PGPSignature)this.signatures.userIdRevocations.get(userId);
    }

    @Nullable
    public PGPSignature getCurrentSubkeyBindingSignature(long keyId) {
        return (PGPSignature)this.signatures.subkeyBindings.get(keyId);
    }

    @Nullable
    public PGPSignature getSubkeyRevocationSignature(long keyId) {
        return (PGPSignature)this.signatures.subkeyRevocations.get(keyId);
    }

    @Nonnull
    public List<KeyFlag> getKeyFlagsOf(long keyId) {
        if (this.getPublicKey().getKeyID() == keyId) {
            PGPSignature userIdSignature;
            List<KeyFlag> keyFlags;
            List<KeyFlag> keyFlags2;
            PGPSignature directKeySignature = this.getLatestDirectKeySelfSignature();
            if (directKeySignature != null && (keyFlags2 = SignatureSubpacketsUtil.parseKeyFlags(directKeySignature)) != null) {
                return keyFlags2;
            }
            String primaryUserId = this.getPrimaryUserId();
            if (primaryUserId != null && (keyFlags = SignatureSubpacketsUtil.parseKeyFlags(userIdSignature = this.getLatestUserIdCertification(primaryUserId))) != null) {
                return keyFlags;
            }
        } else {
            List<KeyFlag> keyFlags;
            PGPSignature bindingSignature = this.getCurrentSubkeyBindingSignature(keyId);
            if (bindingSignature != null && (keyFlags = SignatureSubpacketsUtil.parseKeyFlags(bindingSignature)) != null) {
                return keyFlags;
            }
        }
        return Collections.emptyList();
    }

    @Nonnull
    public List<KeyFlag> getKeyFlagsOf(String userId) {
        if (!this.isUserIdValid(userId)) {
            return Collections.emptyList();
        }
        PGPSignature userIdCertification = this.getLatestUserIdCertification(userId);
        if (userIdCertification == null) {
            throw new AssertionError((Object)("While user-id '" + userId + "' was reported as valid, there appears to be no certification for it."));
        }
        List<KeyFlag> keyFlags = SignatureSubpacketsUtil.parseKeyFlags(userIdCertification);
        if (keyFlags != null) {
            return keyFlags;
        }
        return Collections.emptyList();
    }

    public PublicKeyAlgorithm getAlgorithm() {
        return PublicKeyAlgorithm.fromId(this.getPublicKey().getAlgorithm());
    }

    public Date getCreationDate() {
        return this.getPublicKey().getCreationTime();
    }

    @Nullable
    public Date getLastModified() {
        PGPSignature mostRecent = this.getMostRecentSignature();
        if (mostRecent == null) {
            return this.getLatestKeyCreationDate();
        }
        return mostRecent.getCreationTime();
    }

    @Nonnull
    public Date getLatestKeyCreationDate() {
        Date latestCreation = null;
        for (PGPPublicKey key : this.getPublicKeys()) {
            if (!this.isKeyValidlyBound(key.getKeyID())) continue;
            Date keyCreation = key.getCreationTime();
            if (latestCreation != null && !latestCreation.before(keyCreation)) continue;
            latestCreation = keyCreation;
        }
        if (latestCreation == null) {
            throw new AssertionError((Object)"Apparently there is no validly bound key in this key ring.");
        }
        return latestCreation;
    }

    @Nullable
    private PGPSignature getMostRecentSignature() {
        HashSet<PGPSignature> allSignatures = new HashSet<PGPSignature>();
        PGPSignature mostRecentSelfSignature = this.getLatestDirectKeySelfSignature();
        PGPSignature revocationSelfSignature = this.getRevocationSelfSignature();
        if (mostRecentSelfSignature != null) {
            allSignatures.add(mostRecentSelfSignature);
        }
        if (revocationSelfSignature != null) {
            allSignatures.add(revocationSelfSignature);
        }
        allSignatures.addAll(this.signatures.userIdCertifications.values());
        allSignatures.addAll(this.signatures.userIdRevocations.values());
        allSignatures.addAll(this.signatures.subkeyBindings.values());
        allSignatures.addAll(this.signatures.subkeyRevocations.values());
        PGPSignature mostRecent = null;
        for (PGPSignature signature : allSignatures) {
            if (mostRecent != null && !signature.getCreationTime().after(mostRecent.getCreationTime())) continue;
            mostRecent = signature;
        }
        return mostRecent;
    }

    @Nullable
    public Date getRevocationDate() {
        return this.getRevocationSelfSignature() == null ? null : this.getRevocationSelfSignature().getCreationTime();
    }

    @Nullable
    public Date getPrimaryKeyExpirationDate() {
        Date directKeyExpirationDate;
        PGPSignature directKeySig = this.getLatestDirectKeySelfSignature();
        if (directKeySig != null && (directKeyExpirationDate = SignatureSubpacketsUtil.getKeyExpirationTimeAsDate(directKeySig, this.getPublicKey())) != null) {
            return directKeyExpirationDate;
        }
        PGPSignature primaryUserIdCertification = this.getLatestUserIdCertification(this.getPrimaryUserId());
        if (primaryUserIdCertification != null) {
            return SignatureSubpacketsUtil.getKeyExpirationTimeAsDate(primaryUserIdCertification, this.getPublicKey());
        }
        throw new NoSuchElementException("No suitable signatures found on the key.");
    }

    @Nullable
    public Date getSubkeyExpirationDate(OpenPgpFingerprint fingerprint) {
        if (this.getPublicKey().getKeyID() == fingerprint.getKeyId()) {
            return this.getPrimaryKeyExpirationDate();
        }
        PGPPublicKey subkey = this.getPublicKey(fingerprint.getKeyId());
        if (subkey == null) {
            throw new NoSuchElementException("No subkey with fingerprint " + fingerprint + " found.");
        }
        PGPSignature bindingSig = this.getCurrentSubkeyBindingSignature(fingerprint.getKeyId());
        if (bindingSig == null) {
            throw new AssertionError((Object)"Subkey has no valid binding signature.");
        }
        return SignatureUtils.getKeyExpirationDate(subkey.getCreationTime(), bindingSig);
    }

    public Date getExpirationDateForUse(KeyFlag use) {
        if (use == KeyFlag.SPLIT || use == KeyFlag.SHARED) {
            throw new IllegalArgumentException("SPLIT and SHARED are not uses, but properties.");
        }
        Date primaryExpiration = this.getPrimaryKeyExpirationDate();
        ArrayList<PGPPublicKey> nonExpiringSubkeys = new ArrayList<PGPPublicKey>();
        Date latestSubkeyExpirationDate = null;
        List<PGPPublicKey> keysWithFlag = this.getKeysWithKeyFlag(use);
        if (keysWithFlag.isEmpty()) {
            throw new NoSuchElementException("No key with the required key flag found.");
        }
        for (PGPPublicKey key : keysWithFlag) {
            Date subkeyExpirationDate = this.getSubkeyExpirationDate(OpenPgpFingerprint.of(key));
            if (subkeyExpirationDate == null) {
                nonExpiringSubkeys.add(key);
                continue;
            }
            if (latestSubkeyExpirationDate != null && !subkeyExpirationDate.after(latestSubkeyExpirationDate)) continue;
            latestSubkeyExpirationDate = subkeyExpirationDate;
        }
        if (nonExpiringSubkeys.isEmpty() && latestSubkeyExpirationDate != null) {
            if (primaryExpiration == null) {
                return latestSubkeyExpirationDate;
            }
            if (latestSubkeyExpirationDate.before(primaryExpiration)) {
                return latestSubkeyExpirationDate;
            }
        }
        return primaryExpiration;
    }

    public boolean isSecretKey() {
        if (this.keys instanceof PGPSecretKeyRing) {
            return true;
        }
        if (this.keys instanceof PGPPublicKeyRing) {
            return false;
        }
        throw new AssertionError((Object)("Expected PGPKeyRing to be either PGPPublicKeyRing or PGPSecretKeyRing, but got " + this.keys.getClass().getName() + " instead."));
    }

    public boolean isFullyDecrypted() {
        if (!this.isSecretKey()) {
            return true;
        }
        for (PGPSecretKey secretKey : this.getSecretKeys()) {
            if (KeyInfo.hasDummyS2K(secretKey) || !KeyInfo.isEncrypted(secretKey)) continue;
            return false;
        }
        return true;
    }

    public boolean isFullyEncrypted() {
        if (!this.isSecretKey()) {
            return false;
        }
        for (PGPSecretKey secretKey : this.getSecretKeys()) {
            if (KeyInfo.hasDummyS2K(secretKey) || !KeyInfo.isDecrypted(secretKey)) continue;
            return false;
        }
        return true;
    }

    public int getVersion() {
        return this.keys.getPublicKey().getVersion();
    }

    @Nonnull
    public List<PGPPublicKey> getEncryptionSubkeys(EncryptionPurpose purpose) {
        Date primaryExpiration = this.getPrimaryKeyExpirationDate();
        if (primaryExpiration != null && primaryExpiration.before(new Date())) {
            return Collections.emptyList();
        }
        Iterator<PGPPublicKey> subkeys = this.keys.getPublicKeys();
        ArrayList<PGPPublicKey> encryptionKeys = new ArrayList<PGPPublicKey>();
        while (subkeys.hasNext()) {
            Date subkeyExpiration;
            PGPPublicKey subKey = subkeys.next();
            if (!this.isKeyValidlyBound(subKey.getKeyID()) || (subkeyExpiration = this.getSubkeyExpirationDate(OpenPgpFingerprint.of(subKey))) != null && subkeyExpiration.before(new Date()) || !subKey.isEncryptionKey()) continue;
            List<KeyFlag> keyFlags = this.getKeyFlagsOf(subKey.getKeyID());
            switch (purpose) {
                case COMMUNICATIONS: {
                    if (!keyFlags.contains((Object)KeyFlag.ENCRYPT_COMMS)) break;
                    encryptionKeys.add(subKey);
                    break;
                }
                case STORAGE: {
                    if (!keyFlags.contains((Object)KeyFlag.ENCRYPT_STORAGE)) break;
                    encryptionKeys.add(subKey);
                    break;
                }
                case ANY: {
                    if (!keyFlags.contains((Object)KeyFlag.ENCRYPT_COMMS) && !keyFlags.contains((Object)KeyFlag.ENCRYPT_STORAGE)) break;
                    encryptionKeys.add(subKey);
                }
            }
        }
        return encryptionKeys;
    }

    public List<PGPPublicKey> getKeysWithKeyFlag(KeyFlag flag) {
        ArrayList<PGPPublicKey> keysWithFlag = new ArrayList<PGPPublicKey>();
        for (PGPPublicKey key : this.getPublicKeys()) {
            List<KeyFlag> keyFlags = this.getKeyFlagsOf(key.getKeyID());
            if (!keyFlags.contains((Object)flag)) continue;
            keysWithFlag.add(key);
        }
        return keysWithFlag;
    }

    @Nonnull
    public List<PGPPublicKey> getEncryptionSubkeys(String userId, EncryptionPurpose purpose) {
        if (userId != null && !this.isUserIdValid(userId)) {
            throw new KeyValidationError(userId, this.getLatestUserIdCertification(userId), this.getUserIdRevocation(userId));
        }
        return this.getEncryptionSubkeys(purpose);
    }

    @Nonnull
    public List<PGPPublicKey> getSigningSubkeys() {
        Iterator<PGPPublicKey> subkeys = this.keys.getPublicKeys();
        ArrayList<PGPPublicKey> signingKeys = new ArrayList<PGPPublicKey>();
        while (subkeys.hasNext()) {
            List<KeyFlag> keyFlags;
            PGPPublicKey subKey = subkeys.next();
            if (!this.isKeyValidlyBound(subKey.getKeyID()) || !(keyFlags = this.getKeyFlagsOf(subKey.getKeyID())).contains((Object)KeyFlag.SIGN_DATA)) continue;
            signingKeys.add(subKey);
        }
        return signingKeys;
    }

    public Set<HashAlgorithm> getPreferredHashAlgorithms() {
        return this.getPreferredHashAlgorithms(this.getPrimaryUserId());
    }

    public Set<HashAlgorithm> getPreferredHashAlgorithms(String userId) {
        return this.getKeyAccessor(userId, this.getKeyId()).getPreferredHashAlgorithms();
    }

    public Set<HashAlgorithm> getPreferredHashAlgorithms(long keyId) {
        return this.getKeyAccessor(null, keyId).getPreferredHashAlgorithms();
    }

    public Set<SymmetricKeyAlgorithm> getPreferredSymmetricKeyAlgorithms() {
        return this.getPreferredSymmetricKeyAlgorithms(this.getPrimaryUserId());
    }

    public Set<SymmetricKeyAlgorithm> getPreferredSymmetricKeyAlgorithms(String userId) {
        return this.getKeyAccessor(userId, this.getKeyId()).getPreferredSymmetricKeyAlgorithms();
    }

    public Set<SymmetricKeyAlgorithm> getPreferredSymmetricKeyAlgorithms(long keyId) {
        return this.getKeyAccessor(null, keyId).getPreferredSymmetricKeyAlgorithms();
    }

    public Set<CompressionAlgorithm> getPreferredCompressionAlgorithms() {
        return this.getPreferredCompressionAlgorithms(this.getPrimaryUserId());
    }

    public Set<CompressionAlgorithm> getPreferredCompressionAlgorithms(String userId) {
        return this.getKeyAccessor(userId, this.getKeyId()).getPreferredCompressionAlgorithms();
    }

    public Set<CompressionAlgorithm> getPreferredCompressionAlgorithms(long keyId) {
        return this.getKeyAccessor(null, keyId).getPreferredCompressionAlgorithms();
    }

    private KeyAccessor getKeyAccessor(@Nullable String userId, long keyID) {
        if (this.getPublicKey(keyID) == null) {
            throw new IllegalArgumentException("No subkey with key id " + Long.toHexString(keyID) + " found on this key.");
        }
        if (userId != null && !this.getUserIds().contains(userId)) {
            throw new IllegalArgumentException("No user-id '" + userId + "' found on this key.");
        }
        return userId == null ? new KeyAccessor.ViaKeyId(this, new SubkeyIdentifier(this.keys, keyID)) : new KeyAccessor.ViaUserId(this, new SubkeyIdentifier(this.keys, keyID), userId);
    }

    public static class Signatures {
        private final PGPSignature primaryKeyRevocation;
        private final PGPSignature primaryKeySelfSignature;
        private final Map<String, PGPSignature> userIdRevocations;
        private final Map<String, PGPSignature> userIdCertifications;
        private final Map<Long, PGPSignature> subkeyRevocations;
        private final Map<Long, PGPSignature> subkeyBindings;

        public Signatures(PGPKeyRing keyRing, Date evaluationDate, Policy policy) {
            this.primaryKeyRevocation = SignaturePicker.pickCurrentRevocationSelfSignature(keyRing, policy, evaluationDate);
            this.primaryKeySelfSignature = SignaturePicker.pickLatestDirectKeySignature(keyRing, policy, evaluationDate);
            this.userIdRevocations = new HashMap<String, PGPSignature>();
            this.userIdCertifications = new HashMap<String, PGPSignature>();
            this.subkeyRevocations = new HashMap<Long, PGPSignature>();
            this.subkeyBindings = new HashMap<Long, PGPSignature>();
            Iterator<String> it = keyRing.getPublicKey().getUserIDs();
            while (it.hasNext()) {
                PGPSignature certification;
                String userId = it.next();
                PGPSignature revocation = SignaturePicker.pickCurrentUserIdRevocationSignature(keyRing, userId, policy, evaluationDate);
                if (revocation != null) {
                    this.userIdRevocations.put(userId, revocation);
                }
                if ((certification = SignaturePicker.pickLatestUserIdCertificationSignature(keyRing, userId, policy, evaluationDate)) == null) continue;
                this.userIdCertifications.put(userId, certification);
            }
            Iterator<PGPPublicKey> keys = keyRing.getPublicKeys();
            keys.next();
            while (keys.hasNext()) {
                PGPSignature subkeyBinding;
                PGPPublicKey subkey = keys.next();
                PGPSignature subkeyRevocation = SignaturePicker.pickCurrentSubkeyBindingRevocationSignature(keyRing, subkey, policy, evaluationDate);
                if (subkeyRevocation != null) {
                    this.subkeyRevocations.put(subkey.getKeyID(), subkeyRevocation);
                }
                if ((subkeyBinding = SignaturePicker.pickLatestSubkeyBindingSignature(keyRing, subkey, policy, evaluationDate)) == null) continue;
                this.subkeyBindings.put(subkey.getKeyID(), subkeyBinding);
            }
        }
    }
}

