/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.key.protection;

import java.util.Iterator;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPKeyRing;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.bouncycastle.openpgp.operator.PBESecretKeyDecryptor;
import org.bouncycastle.openpgp.operator.PBESecretKeyEncryptor;
import org.pgpainless.implementation.ImplementationFactory;
import org.pgpainless.key.protection.KeyRingProtectionSettings;
import org.pgpainless.key.protection.SecretKeyRingProtector;
import org.pgpainless.key.protection.passphrase_provider.SecretKeyPassphraseProvider;
import org.pgpainless.util.Passphrase;

public class PasswordBasedSecretKeyRingProtector
implements SecretKeyRingProtector {
    protected final KeyRingProtectionSettings protectionSettings;
    protected final SecretKeyPassphraseProvider passphraseProvider;

    public PasswordBasedSecretKeyRingProtector(@Nonnull KeyRingProtectionSettings settings, @Nonnull SecretKeyPassphraseProvider passphraseProvider) {
        this.protectionSettings = settings;
        this.passphraseProvider = passphraseProvider;
    }

    public static PasswordBasedSecretKeyRingProtector forKey(final PGPKeyRing keyRing, final Passphrase passphrase) {
        KeyRingProtectionSettings protectionSettings = KeyRingProtectionSettings.secureDefaultSettings();
        SecretKeyPassphraseProvider passphraseProvider = new SecretKeyPassphraseProvider(){

            @Override
            @Nullable
            public Passphrase getPassphraseFor(Long keyId) {
                Iterator<PGPPublicKey> it = keyRing.getPublicKeys();
                while (it.hasNext()) {
                    PGPPublicKey key = it.next();
                    if (key.getKeyID() != keyId.longValue()) continue;
                    return passphrase;
                }
                return null;
            }

            @Override
            public boolean hasPassphrase(Long keyId) {
                return keyRing.getPublicKey(keyId) != null;
            }
        };
        return new PasswordBasedSecretKeyRingProtector(protectionSettings, passphraseProvider);
    }

    public static PasswordBasedSecretKeyRingProtector forKey(final PGPSecretKey key, final Passphrase passphrase) {
        KeyRingProtectionSettings protectionSettings = KeyRingProtectionSettings.secureDefaultSettings();
        SecretKeyPassphraseProvider passphraseProvider = new SecretKeyPassphraseProvider(){

            @Override
            @Nullable
            public Passphrase getPassphraseFor(Long keyId) {
                if (key.getKeyID() == keyId.longValue()) {
                    return passphrase;
                }
                return null;
            }

            @Override
            public boolean hasPassphrase(Long keyId) {
                return keyId.longValue() == key.getKeyID();
            }
        };
        return new PasswordBasedSecretKeyRingProtector(protectionSettings, passphraseProvider);
    }

    @Override
    public boolean hasPassphraseFor(Long keyId) {
        return this.passphraseProvider.hasPassphrase(keyId);
    }

    @Override
    @Nullable
    public PBESecretKeyDecryptor getDecryptor(Long keyId) throws PGPException {
        Passphrase passphrase = this.passphraseProvider.getPassphraseFor(keyId);
        return passphrase == null ? null : ImplementationFactory.getInstance().getPBESecretKeyDecryptor(passphrase);
    }

    @Override
    @Nullable
    public PBESecretKeyEncryptor getEncryptor(Long keyId) throws PGPException {
        Passphrase passphrase = this.passphraseProvider.getPassphraseFor(keyId);
        return passphrase == null ? null : ImplementationFactory.getInstance().getPBESecretKeyEncryptor(this.protectionSettings.getEncryptionAlgorithm(), this.protectionSettings.getHashAlgorithm(), this.protectionSettings.getS2kCount(), passphrase);
    }
}

