/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.algorithm;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public enum CompressionAlgorithm {
    UNCOMPRESSED(0),
    ZIP(1),
    ZLIB(2),
    BZIP2(3);

    private static final Map<Integer, CompressionAlgorithm> MAP;
    private final int algorithmId;

    public static CompressionAlgorithm fromId(int id) {
        return MAP.get(id);
    }

    private CompressionAlgorithm(int id) {
        this.algorithmId = id;
    }

    public int getAlgorithmId() {
        return this.algorithmId;
    }

    static {
        MAP = new ConcurrentHashMap<Integer, CompressionAlgorithm>();
        for (CompressionAlgorithm c : CompressionAlgorithm.values()) {
            MAP.put(c.algorithmId, c);
        }
    }
}

