/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.decryption_verification.cleartext_signatures;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.bouncycastle.bcpg.ArmoredInputStream;
import org.bouncycastle.openpgp.PGPObjectFactory;
import org.bouncycastle.openpgp.PGPSignatureList;
import org.bouncycastle.util.Strings;
import org.pgpainless.exception.WrongConsumingMethodException;
import org.pgpainless.implementation.ImplementationFactory;
import org.pgpainless.util.ArmoredInputStreamFactory;

public final class ClearsignedMessageUtil {
    private ClearsignedMessageUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PGPSignatureList detachSignaturesFromInbandClearsignedMessage(InputStream clearsignedInputStream, OutputStream messageOutputStream) throws IOException, WrongConsumingMethodException {
        ArmoredInputStream in = ArmoredInputStreamFactory.get(clearsignedInputStream);
        if (!in.isClearText()) {
            throw new WrongConsumingMethodException("Message is not using the Cleartext Signature Framework.");
        }
        try (BufferedOutputStream out = new BufferedOutputStream(messageOutputStream);){
            ByteArrayOutputStream lineOut = new ByteArrayOutputStream();
            int lookAhead = ClearsignedMessageUtil.readInputLine(lineOut, in);
            byte[] lineSep = ClearsignedMessageUtil.getLineSeparator();
            if (lookAhead != -1 && in.isClearText()) {
                byte[] line = lineOut.toByteArray();
                ((OutputStream)out).write(line, 0, ClearsignedMessageUtil.getLengthWithoutSeparatorOrTrailingWhitespace(line));
                while (lookAhead != -1 && in.isClearText()) {
                    lookAhead = ClearsignedMessageUtil.readInputLine(lineOut, lookAhead, in);
                    line = lineOut.toByteArray();
                    ((OutputStream)out).write(lineSep);
                    ((OutputStream)out).write(line, 0, ClearsignedMessageUtil.getLengthWithoutSeparatorOrTrailingWhitespace(line));
                }
            } else if (lookAhead != -1) {
                byte[] line = lineOut.toByteArray();
                ((OutputStream)out).write(line, 0, ClearsignedMessageUtil.getLengthWithoutSeparatorOrTrailingWhitespace(line));
            }
        }
        PGPObjectFactory objectFactory = new PGPObjectFactory(in, ImplementationFactory.getInstance().getKeyFingerprintCalculator());
        PGPSignatureList signatures = (PGPSignatureList)objectFactory.nextObject();
        return signatures;
    }

    public static int readInputLine(ByteArrayOutputStream bOut, InputStream fIn) throws IOException {
        int ch;
        bOut.reset();
        int lookAhead = -1;
        while ((ch = fIn.read()) >= 0) {
            bOut.write(ch);
            if (ch != 13 && ch != 10) continue;
            lookAhead = ClearsignedMessageUtil.readPassedEOL(bOut, ch, fIn);
            break;
        }
        return lookAhead;
    }

    public static int readInputLine(ByteArrayOutputStream bOut, int lookAhead, InputStream fIn) throws IOException {
        bOut.reset();
        int ch = lookAhead;
        do {
            bOut.write(ch);
            if (ch != 13 && ch != 10) continue;
            lookAhead = ClearsignedMessageUtil.readPassedEOL(bOut, ch, fIn);
            break;
        } while ((ch = fIn.read()) >= 0);
        if (ch < 0) {
            lookAhead = -1;
        }
        return lookAhead;
    }

    private static int readPassedEOL(ByteArrayOutputStream bOut, int lastCh, InputStream fIn) throws IOException {
        int lookAhead = fIn.read();
        if (lastCh == 13 && lookAhead == 10) {
            bOut.write(lookAhead);
            lookAhead = fIn.read();
        }
        return lookAhead;
    }

    private static byte[] getLineSeparator() {
        String nl = Strings.lineSeparator();
        byte[] nlBytes = new byte[nl.length()];
        for (int i = 0; i != nlBytes.length; ++i) {
            nlBytes[i] = (byte)nl.charAt(i);
        }
        return nlBytes;
    }

    private static int getLengthWithoutSeparatorOrTrailingWhitespace(byte[] line) {
        int end;
        for (end = line.length - 1; end >= 0 && ClearsignedMessageUtil.isWhiteSpace(line[end]); --end) {
        }
        return end + 1;
    }

    private static boolean isLineEnding(byte b) {
        return b == 13 || b == 10;
    }

    private static boolean isWhiteSpace(byte b) {
        return ClearsignedMessageUtil.isLineEnding(b) || b == 9 || b == 32;
    }
}

