/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.key.protection;

import javax.annotation.Nullable;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.operator.PBESecretKeyDecryptor;
import org.bouncycastle.openpgp.operator.PBESecretKeyEncryptor;
import org.pgpainless.implementation.ImplementationFactory;
import org.pgpainless.key.protection.KeyRingProtectionSettings;
import org.pgpainless.key.protection.SecretKeyRingProtector;
import org.pgpainless.key.protection.passphrase_provider.SecretKeyPassphraseProvider;
import org.pgpainless.util.Passphrase;

public class BaseSecretKeyRingProtector
implements SecretKeyRingProtector {
    private final SecretKeyPassphraseProvider passphraseProvider;
    private final KeyRingProtectionSettings protectionSettings;

    public BaseSecretKeyRingProtector(SecretKeyPassphraseProvider passphraseProvider) {
        this(passphraseProvider, KeyRingProtectionSettings.secureDefaultSettings());
    }

    public BaseSecretKeyRingProtector(SecretKeyPassphraseProvider passphraseProvider, KeyRingProtectionSettings protectionSettings) {
        this.passphraseProvider = passphraseProvider;
        this.protectionSettings = protectionSettings;
    }

    @Override
    public boolean hasPassphraseFor(Long keyId) {
        return this.passphraseProvider.hasPassphrase(keyId);
    }

    @Override
    @Nullable
    public PBESecretKeyDecryptor getDecryptor(Long keyId) throws PGPException {
        Passphrase passphrase = this.passphraseProvider.getPassphraseFor(keyId);
        return passphrase == null ? null : ImplementationFactory.getInstance().getPBESecretKeyDecryptor(passphrase);
    }

    @Override
    @Nullable
    public PBESecretKeyEncryptor getEncryptor(Long keyId) throws PGPException {
        Passphrase passphrase = this.passphraseProvider.getPassphraseFor(keyId);
        return passphrase == null ? null : ImplementationFactory.getInstance().getPBESecretKeyEncryptor(this.protectionSettings.getEncryptionAlgorithm(), this.protectionSettings.getHashAlgorithm(), this.protectionSettings.getS2kCount(), passphrase);
    }
}

