/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.signature.builder;

import java.util.Set;
import javax.annotation.Nonnull;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPPrivateKey;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.bouncycastle.openpgp.PGPSignature;
import org.bouncycastle.openpgp.PGPSignatureGenerator;
import org.pgpainless.PGPainless;
import org.pgpainless.algorithm.HashAlgorithm;
import org.pgpainless.algorithm.SignatureType;
import org.pgpainless.algorithm.negotiation.HashAlgorithmNegotiator;
import org.pgpainless.exception.WrongPassphraseException;
import org.pgpainless.implementation.ImplementationFactory;
import org.pgpainless.key.protection.SecretKeyRingProtector;
import org.pgpainless.key.protection.UnlockSecretKey;
import org.pgpainless.key.util.OpenPgpKeyAttributeUtil;
import org.pgpainless.signature.subpackets.SignatureSubpackets;
import org.pgpainless.signature.subpackets.SignatureSubpacketsHelper;

public abstract class AbstractSignatureBuilder<B extends AbstractSignatureBuilder<B>> {
    protected final PGPPrivateKey privateSigningKey;
    protected final PGPPublicKey publicSigningKey;
    protected HashAlgorithm hashAlgorithm;
    protected SignatureType signatureType;
    protected SignatureSubpackets unhashedSubpackets;
    protected SignatureSubpackets hashedSubpackets;

    protected AbstractSignatureBuilder(SignatureType signatureType, PGPSecretKey signingKey, SecretKeyRingProtector protector, HashAlgorithm hashAlgorithm, SignatureSubpackets hashedSubpackets, SignatureSubpackets unhashedSubpackets) throws WrongPassphraseException {
        if (!this.isValidSignatureType(signatureType)) {
            throw new IllegalArgumentException("Invalid signature type.");
        }
        this.signatureType = signatureType;
        this.privateSigningKey = UnlockSecretKey.unlockSecretKey(signingKey, protector);
        this.publicSigningKey = signingKey.getPublicKey();
        this.hashAlgorithm = hashAlgorithm;
        this.hashedSubpackets = hashedSubpackets;
        this.unhashedSubpackets = unhashedSubpackets;
    }

    public AbstractSignatureBuilder(SignatureType signatureType, PGPSecretKey signingKey, SecretKeyRingProtector protector) throws WrongPassphraseException {
        this(signatureType, signingKey, protector, AbstractSignatureBuilder.negotiateHashAlgorithm(signingKey.getPublicKey()), SignatureSubpackets.createHashedSubpackets(signingKey.getPublicKey()), SignatureSubpackets.createEmptySubpackets());
    }

    public AbstractSignatureBuilder(PGPSecretKey certificationKey, SecretKeyRingProtector protector, PGPSignature archetypeSignature) throws WrongPassphraseException {
        this(SignatureType.valueOf(archetypeSignature.getSignatureType()), certificationKey, protector, AbstractSignatureBuilder.negotiateHashAlgorithm(certificationKey.getPublicKey()), SignatureSubpackets.refreshHashedSubpackets(certificationKey.getPublicKey(), archetypeSignature), SignatureSubpackets.refreshUnhashedSubpackets(archetypeSignature));
    }

    protected static HashAlgorithm negotiateHashAlgorithm(PGPPublicKey publicKey) {
        Set<HashAlgorithm> hashAlgorithmPreferences = OpenPgpKeyAttributeUtil.getOrGuessPreferredHashAlgorithms(publicKey);
        return HashAlgorithmNegotiator.negotiateSignatureHashAlgorithm(PGPainless.getPolicy()).negotiateHashAlgorithm(hashAlgorithmPreferences);
    }

    public B overrideHashAlgorithm(@Nonnull HashAlgorithm hashAlgorithm) {
        this.hashAlgorithm = hashAlgorithm;
        return (B)this;
    }

    public B setSignatureType(SignatureType type) {
        if (!this.isValidSignatureType(type)) {
            throw new IllegalArgumentException("Invalid signature type: " + (Object)((Object)type));
        }
        this.signatureType = type;
        return (B)this;
    }

    protected PGPSignatureGenerator buildAndInitSignatureGenerator() throws PGPException {
        PGPSignatureGenerator generator = new PGPSignatureGenerator(ImplementationFactory.getInstance().getPGPContentSignerBuilder(this.publicSigningKey.getAlgorithm(), this.hashAlgorithm.getAlgorithmId()));
        generator.setUnhashedSubpackets(SignatureSubpacketsHelper.toVector(this.unhashedSubpackets));
        generator.setHashedSubpackets(SignatureSubpacketsHelper.toVector(this.hashedSubpackets));
        generator.init(this.signatureType.getCode(), this.privateSigningKey);
        return generator;
    }

    protected abstract boolean isValidSignatureType(SignatureType var1);
}

