/*
 * Decompiled with CFR 0.152.
 */
package sop.util;

public class Optional<T> {
    private final T item;

    public Optional() {
        this(null);
    }

    public Optional(T item) {
        this.item = item;
    }

    public static <T> Optional<T> of(T item) {
        if (item == null) {
            throw new NullPointerException("Item cannot be null.");
        }
        return new Optional<T>(item);
    }

    public static <T> Optional<T> ofNullable(T item) {
        return new Optional<T>(item);
    }

    public static <T> Optional<T> ofEmpty() {
        return new Optional<Object>(null);
    }

    public T get() {
        return this.item;
    }

    public boolean isPresent() {
        return this.item != null;
    }

    public boolean isEmpty() {
        return this.item == null;
    }
}

