/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.cli.commands;

import com.ginsberg.junit.exit.FailOnSystemExit;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.pgpainless.PGPainless;
import org.pgpainless.cli.PGPainlessCLI;

public class ArmorTest {
    private static PrintStream originalSout;

    @BeforeEach
    public void saveSout() {
        originalSout = System.out;
    }

    @AfterEach
    public void restoreSout() {
        System.setOut(originalSout);
    }

    @Test
    @FailOnSystemExit
    public void armorSecretKey() throws IOException, PGPException, InvalidAlgorithmParameterException, NoSuchAlgorithmException {
        PGPSecretKeyRing secretKey = PGPainless.generateKeyRing().modernKeyRing("alice@pgpainless.org", null);
        byte[] bytes = secretKey.getEncoded();
        System.setIn(new ByteArrayInputStream(bytes));
        ByteArrayOutputStream armorOut = new ByteArrayOutputStream();
        System.setOut(new PrintStream(armorOut));
        PGPainlessCLI.execute((String[])new String[]{"armor"});
        PGPSecretKeyRing armored = PGPainless.readKeyRing().secretKeyRing(armorOut.toString());
        Assertions.assertArrayEquals((byte[])secretKey.getEncoded(), (byte[])armored.getEncoded());
    }

    @Test
    @FailOnSystemExit
    public void armorPublicKey() throws PGPException, InvalidAlgorithmParameterException, NoSuchAlgorithmException, IOException {
        PGPSecretKeyRing secretKey = PGPainless.generateKeyRing().modernKeyRing("alice@pgpainless.org", null);
        PGPPublicKeyRing publicKey = PGPainless.extractCertificate((PGPSecretKeyRing)secretKey);
        byte[] bytes = publicKey.getEncoded();
        System.setIn(new ByteArrayInputStream(bytes));
        ByteArrayOutputStream armorOut = new ByteArrayOutputStream();
        System.setOut(new PrintStream(armorOut));
        PGPainlessCLI.execute((String[])new String[]{"armor"});
        PGPPublicKeyRing armored = PGPainless.readKeyRing().publicKeyRing(armorOut.toString());
        Assertions.assertArrayEquals((byte[])publicKey.getEncoded(), (byte[])armored.getEncoded());
    }

    @Test
    @FailOnSystemExit
    public void armorMessage() {
        String message = "Hello, World!\n";
        System.setIn(new ByteArrayInputStream(message.getBytes(StandardCharsets.UTF_8)));
        ByteArrayOutputStream armorOut = new ByteArrayOutputStream();
        System.setOut(new PrintStream(armorOut));
        PGPainlessCLI.execute((String[])new String[]{"armor"});
        String armored = armorOut.toString();
        Assertions.assertTrue((boolean)armored.startsWith("-----BEGIN PGP MESSAGE-----\n"));
        Assertions.assertTrue((boolean)armored.contains("SGVsbG8sIFdvcmxkIQo="));
    }
}

