/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.decryption_verification.cleartext_signatures;

import java.io.IOException;
import java.io.InputStream;
import org.bouncycastle.bcpg.ArmoredInputStream;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPSignature;
import org.bouncycastle.openpgp.PGPSignatureList;
import org.pgpainless.PGPainless;
import org.pgpainless.algorithm.CompressionAlgorithm;
import org.pgpainless.algorithm.StreamEncoding;
import org.pgpainless.algorithm.SymmetricKeyAlgorithm;
import org.pgpainless.decryption_verification.ConsumerOptions;
import org.pgpainless.decryption_verification.DecryptionStream;
import org.pgpainless.decryption_verification.OpenPgpMetadata;
import org.pgpainless.decryption_verification.cleartext_signatures.ClearsignedMessageUtil;
import org.pgpainless.decryption_verification.cleartext_signatures.MultiPassStrategy;
import org.pgpainless.util.ArmoredInputStreamFactory;

public class CleartextSignatureProcessor {
    private final ArmoredInputStream in;
    private final ConsumerOptions options;

    public CleartextSignatureProcessor(InputStream inputStream, ConsumerOptions options) throws IOException {
        this.in = inputStream instanceof ArmoredInputStream ? (ArmoredInputStream)inputStream : ArmoredInputStreamFactory.get(inputStream);
        this.options = options;
    }

    public DecryptionStream getVerificationStream() throws IOException, PGPException {
        OpenPgpMetadata.Builder resultBuilder = OpenPgpMetadata.getBuilder();
        resultBuilder.setCompressionAlgorithm(CompressionAlgorithm.UNCOMPRESSED).setSymmetricKeyAlgorithm(SymmetricKeyAlgorithm.NULL).setFileEncoding(StreamEncoding.TEXT);
        MultiPassStrategy multiPassStrategy = this.options.getMultiPassStrategy();
        PGPSignatureList signatures = ClearsignedMessageUtil.detachSignaturesFromInbandClearsignedMessage(this.in, multiPassStrategy.getMessageOutputStream());
        for (PGPSignature signature : signatures) {
            this.options.addVerificationOfDetachedSignature(signature);
        }
        this.options.setIsCleartextSigned();
        return PGPainless.decryptAndOrVerify().onInputStream(multiPassStrategy.getMessageInputStream()).withOptions(this.options);
    }
}

