/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.signature.builder;

import javax.annotation.Nullable;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.bouncycastle.openpgp.PGPSignature;
import org.bouncycastle.openpgp.PGPSignatureGenerator;
import org.pgpainless.algorithm.SignatureType;
import org.pgpainless.exception.WrongPassphraseException;
import org.pgpainless.key.protection.SecretKeyRingProtector;
import org.pgpainless.signature.builder.AbstractSignatureBuilder;
import org.pgpainless.signature.subpackets.RevocationSignatureSubpackets;

public class RevocationSignatureBuilder
extends AbstractSignatureBuilder<RevocationSignatureBuilder> {
    public RevocationSignatureBuilder(SignatureType signatureType, PGPSecretKey signingKey, SecretKeyRingProtector protector) throws WrongPassphraseException {
        super(signatureType, signingKey, protector);
        this.getHashedSubpackets().setRevocable(true, false);
    }

    @Override
    protected boolean isValidSignatureType(SignatureType type) {
        switch (type) {
            case KEY_REVOCATION: 
            case SUBKEY_REVOCATION: 
            case CERTIFICATION_REVOCATION: {
                return true;
            }
        }
        return false;
    }

    public RevocationSignatureSubpackets getHashedSubpackets() {
        return this.hashedSubpackets;
    }

    public RevocationSignatureSubpackets getUnhashedSubpackets() {
        return this.unhashedSubpackets;
    }

    public void applyCallback(@Nullable RevocationSignatureSubpackets.Callback callback) {
        if (callback != null) {
            callback.modifyHashedSubpackets(this.getHashedSubpackets());
            callback.modifyUnhashedSubpackets(this.getUnhashedSubpackets());
        }
    }

    public PGPSignature build(PGPPublicKey revokeeSubkey) throws PGPException {
        PGPSignatureGenerator signatureGenerator = this.buildAndInitSignatureGenerator();
        if (this.signatureType == SignatureType.KEY_REVOCATION) {
            if (revokeeSubkey.getKeyID() != this.publicSigningKey.getKeyID()) {
                throw new IllegalArgumentException("Signature type is KEY_REVOCATION, but provided revokeeSubkey is != signingPublicKey.");
            }
            return signatureGenerator.generateCertification(this.publicSigningKey);
        }
        return signatureGenerator.generateCertification(this.publicSigningKey, revokeeSubkey);
    }

    public PGPSignature build(String revokeeUserId) throws PGPException {
        PGPSignatureGenerator signatureGenerator = this.buildAndInitSignatureGenerator();
        if (this.signatureType != SignatureType.CERTIFICATION_REVOCATION) {
            throw new IllegalArgumentException("Signature type is != CERTIFICATION_REVOCATION.");
        }
        return signatureGenerator.generateCertification(revokeeUserId, this.publicSigningKey);
    }
}

