/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.sop;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Date;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPPublicKeyRingCollection;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.bouncycastle.openpgp.PGPSecretKeyRingCollection;
import org.bouncycastle.openpgp.PGPSignature;
import org.bouncycastle.util.io.Streams;
import org.pgpainless.PGPainless;
import org.pgpainless.decryption_verification.ConsumerOptions;
import org.pgpainless.decryption_verification.DecryptionStream;
import org.pgpainless.decryption_verification.OpenPgpMetadata;
import org.pgpainless.key.SubkeyIdentifier;
import org.pgpainless.key.info.KeyRingInfo;
import org.pgpainless.key.protection.SecretKeyRingProtector;
import org.pgpainless.util.Passphrase;
import sop.DecryptionResult;
import sop.ReadyWithResult;
import sop.SessionKey;
import sop.Verification;
import sop.exception.SOPGPException;
import sop.operation.Decrypt;

public class DecryptImpl
implements Decrypt {
    private final ConsumerOptions consumerOptions = new ConsumerOptions();

    @Override
    public DecryptImpl verifyNotBefore(Date timestamp) throws SOPGPException.UnsupportedOption {
        this.consumerOptions.verifyNotBefore(timestamp);
        return this;
    }

    @Override
    public DecryptImpl verifyNotAfter(Date timestamp) throws SOPGPException.UnsupportedOption {
        this.consumerOptions.verifyNotAfter(timestamp);
        return this;
    }

    @Override
    public DecryptImpl verifyWithCert(InputStream certIn) throws SOPGPException.BadData, IOException {
        try {
            PGPPublicKeyRingCollection certs = PGPainless.readKeyRing().keyRingCollection(certIn, false).getPgpPublicKeyRingCollection();
            if (certs.size() == 0) {
                throw new SOPGPException.BadData(new PGPException("No certificates provided."));
            }
            this.consumerOptions.addVerificationCerts(certs);
        }
        catch (PGPException e) {
            throw new SOPGPException.BadData(e);
        }
        return this;
    }

    @Override
    public DecryptImpl withSessionKey(SessionKey sessionKey) throws SOPGPException.UnsupportedOption {
        throw new SOPGPException.UnsupportedOption("Setting custom session key not supported.");
    }

    @Override
    public DecryptImpl withPassword(String password) {
        this.consumerOptions.addDecryptionPassphrase(Passphrase.fromPassword(password));
        String withoutTrailingWhitespace = DecryptImpl.removeTrailingWhitespace(password);
        if (!password.equals(withoutTrailingWhitespace)) {
            this.consumerOptions.addDecryptionPassphrase(Passphrase.fromPassword(withoutTrailingWhitespace));
        }
        return this;
    }

    private static String removeTrailingWhitespace(String passphrase) {
        int i;
        for (i = passphrase.length() - 1; i > 0 && Character.isWhitespace(passphrase.charAt(i)); --i) {
        }
        return passphrase.substring(0, i);
    }

    @Override
    public DecryptImpl withKey(InputStream keyIn) throws SOPGPException.KeyIsProtected, SOPGPException.BadData, SOPGPException.UnsupportedAsymmetricAlgo {
        try {
            PGPSecretKeyRingCollection secretKeys = PGPainless.readKeyRing().secretKeyRingCollection(keyIn);
            if (secretKeys.size() != 1) {
                throw new SOPGPException.BadData((Throwable)((Object)new AssertionError((Object)("Exactly one single secret key expected. Got " + secretKeys.size()))));
            }
            for (PGPSecretKeyRing secretKey : secretKeys) {
                KeyRingInfo info = new KeyRingInfo(secretKey);
                if (info.isFullyDecrypted()) continue;
                throw new SOPGPException.KeyIsProtected();
            }
            this.consumerOptions.addDecryptionKeys(secretKeys, SecretKeyRingProtector.unprotectedKeys());
        }
        catch (IOException | PGPException e) {
            throw new SOPGPException.BadData(e);
        }
        return this;
    }

    @Override
    public ReadyWithResult<DecryptionResult> ciphertext(InputStream ciphertext) throws SOPGPException.BadData, SOPGPException.MissingArg {
        DecryptionStream decryptionStream;
        if (this.consumerOptions.getDecryptionKeys().isEmpty() && this.consumerOptions.getDecryptionPassphrases().isEmpty()) {
            throw new SOPGPException.MissingArg("Missing decryption key or passphrase.");
        }
        try {
            decryptionStream = PGPainless.decryptAndOrVerify().onInputStream(ciphertext).withOptions(this.consumerOptions);
        }
        catch (IOException | PGPException e) {
            throw new SOPGPException.BadData(e);
        }
        return new ReadyWithResult<DecryptionResult>(){

            @Override
            public DecryptionResult writeTo(OutputStream outputStream) throws IOException, SOPGPException.NoSignature {
                Streams.pipeAll(decryptionStream, outputStream);
                decryptionStream.close();
                OpenPgpMetadata metadata = decryptionStream.getResult();
                ArrayList<Verification> verificationList = new ArrayList<Verification>();
                for (SubkeyIdentifier verifiedSigningKey : metadata.getVerifiedSignatures().keySet()) {
                    PGPSignature signature = metadata.getVerifiedSignatures().get(verifiedSigningKey);
                    verificationList.add(new Verification(signature.getCreationTime(), verifiedSigningKey.getSubkeyFingerprint().toString(), verifiedSigningKey.getPrimaryKeyFingerprint().toString()));
                }
                if (!DecryptImpl.this.consumerOptions.getCertificates().isEmpty() && verificationList.isEmpty()) {
                    throw new SOPGPException.NoSignature();
                }
                return new DecryptionResult(null, verificationList);
            }
        };
    }
}

