/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.cli.commands;

import com.ginsberg.junit.exit.FailOnSystemExit;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.pgpainless.cli.PGPainlessCLI;
import org.pgpainless.cli.TestUtils;

public class EncryptDecryptTest {
    private static File tempDir;
    private static PrintStream originalSout;

    @BeforeAll
    public static void prepare() throws IOException {
        tempDir = TestUtils.createTempDirectory();
    }

    @Test
    @FailOnSystemExit
    public void encryptAndDecryptAMessage() throws IOException {
        originalSout = System.out;
        File julietKeyFile = new File(tempDir, "juliet.key");
        Assertions.assertTrue((boolean)julietKeyFile.createNewFile());
        File julietCertFile = new File(tempDir, "juliet.asc");
        Assertions.assertTrue((boolean)julietCertFile.createNewFile());
        File romeoKeyFile = new File(tempDir, "romeo.key");
        Assertions.assertTrue((boolean)romeoKeyFile.createNewFile());
        File romeoCertFile = new File(tempDir, "romeo.asc");
        Assertions.assertTrue((boolean)romeoCertFile.createNewFile());
        File msgAscFile = new File(tempDir, "msg.asc");
        Assertions.assertTrue((boolean)msgAscFile.createNewFile());
        FileOutputStream julietKeyOut = new FileOutputStream(julietKeyFile);
        System.setOut(new PrintStream(julietKeyOut));
        PGPainlessCLI.execute((String[])new String[]{"generate-key", "Juliet Capulet <juliet@capulet.lit>"});
        ((OutputStream)julietKeyOut).close();
        FileInputStream julietKeyIn = new FileInputStream(julietKeyFile);
        System.setIn(julietKeyIn);
        FileOutputStream julietCertOut = new FileOutputStream(julietCertFile);
        System.setOut(new PrintStream(julietCertOut));
        PGPainlessCLI.execute((String[])new String[]{"extract-cert"});
        julietKeyIn.close();
        ((OutputStream)julietCertOut).close();
        FileOutputStream romeoKeyOut = new FileOutputStream(romeoKeyFile);
        System.setOut(new PrintStream(romeoKeyOut));
        PGPainlessCLI.execute((String[])new String[]{"generate-key", "Romeo Montague <romeo@montague.lit>"});
        ((OutputStream)romeoKeyOut).close();
        FileInputStream romeoKeyIn = new FileInputStream(romeoKeyFile);
        System.setIn(romeoKeyIn);
        FileOutputStream romeoCertOut = new FileOutputStream(romeoCertFile);
        System.setOut(new PrintStream(romeoCertOut));
        PGPainlessCLI.execute((String[])new String[]{"extract-cert"});
        romeoKeyIn.close();
        ((OutputStream)romeoCertOut).close();
        String msg = "Hello World!\n";
        ByteArrayInputStream msgIn = new ByteArrayInputStream(msg.getBytes(StandardCharsets.UTF_8));
        System.setIn(msgIn);
        FileOutputStream msgAscOut = new FileOutputStream(msgAscFile);
        System.setOut(new PrintStream(msgAscOut));
        PGPainlessCLI.execute((String[])new String[]{"encrypt", "--sign-with", romeoKeyFile.getAbsolutePath(), julietCertFile.getAbsolutePath()});
        ((OutputStream)msgAscOut).close();
        File verifyFile = new File(tempDir, "verify.txt");
        FileInputStream msgAscIn = new FileInputStream(msgAscFile);
        System.setIn(msgAscIn);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        PrintStream pOut = new PrintStream(out);
        System.setOut(pOut);
        PGPainlessCLI.execute((String[])new String[]{"decrypt", "--verify-out", verifyFile.getAbsolutePath(), "--verify-with", romeoCertFile.getAbsolutePath(), julietKeyFile.getAbsolutePath()});
        msgAscIn.close();
        Assertions.assertEquals((Object)msg, (Object)out.toString());
    }

    @AfterAll
    public static void after() {
        System.setOut(originalSout);
        System.out.println(tempDir.getAbsolutePath());
    }
}

