/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.util;

import javax.annotation.Nonnull;
import org.bouncycastle.openpgp.PGPSessionKey;
import org.pgpainless.algorithm.SymmetricKeyAlgorithm;

public class SessionKey {
    private final SymmetricKeyAlgorithm algorithm;
    private final byte[] key;

    public SessionKey(@Nonnull PGPSessionKey sessionKey) {
        this(SymmetricKeyAlgorithm.fromId(sessionKey.getAlgorithm()), sessionKey.getKey());
    }

    public SessionKey(@Nonnull SymmetricKeyAlgorithm algorithm, @Nonnull byte[] key) {
        this.algorithm = algorithm;
        this.key = key;
    }

    public SymmetricKeyAlgorithm getAlgorithm() {
        return this.algorithm;
    }

    public byte[] getKey() {
        byte[] copy = new byte[this.key.length];
        System.arraycopy(this.key, 0, copy, 0, copy.length);
        return copy;
    }
}

