/*
 * Decompiled with CFR 0.152.
 */
package sop.operation;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import sop.Ready;
import sop.enums.EncryptAs;
import sop.exception.SOPGPException;

public interface Encrypt {
    public Encrypt noArmor();

    public Encrypt mode(EncryptAs var1) throws SOPGPException.UnsupportedOption;

    public Encrypt signWith(InputStream var1) throws SOPGPException.KeyIsProtected, SOPGPException.KeyCannotSign, SOPGPException.UnsupportedAsymmetricAlgo, SOPGPException.BadData;

    default public Encrypt signWith(byte[] key) throws SOPGPException.KeyIsProtected, SOPGPException.KeyCannotSign, SOPGPException.UnsupportedAsymmetricAlgo, SOPGPException.BadData {
        return this.signWith(new ByteArrayInputStream(key));
    }

    public Encrypt withPassword(String var1) throws SOPGPException.PasswordNotHumanReadable, SOPGPException.UnsupportedOption;

    public Encrypt withCert(InputStream var1) throws SOPGPException.CertCannotEncrypt, SOPGPException.UnsupportedAsymmetricAlgo, SOPGPException.BadData;

    default public Encrypt withCert(byte[] cert) throws SOPGPException.CertCannotEncrypt, SOPGPException.UnsupportedAsymmetricAlgo, SOPGPException.BadData {
        return this.withCert(new ByteArrayInputStream(cert));
    }

    public Ready plaintext(InputStream var1) throws IOException;

    default public Ready plaintext(byte[] plaintext) throws IOException {
        return this.plaintext(new ByteArrayInputStream(plaintext));
    }
}

