/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.cli.commands;

import com.ginsberg.junit.exit.FailOnSystemExit;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPKeyRing;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.pgpainless.PGPainless;
import org.pgpainless.cli.PGPainlessCLI;

public class DearmorTest {
    private PrintStream originalSout;

    @BeforeEach
    public void saveSout() {
        this.originalSout = System.out;
    }

    @AfterEach
    public void restoreSout() {
        System.setOut(this.originalSout);
    }

    @Test
    @FailOnSystemExit
    public void dearmorSecretKey() throws PGPException, InvalidAlgorithmParameterException, NoSuchAlgorithmException, IOException {
        PGPSecretKeyRing secretKey = PGPainless.generateKeyRing().modernKeyRing("alice@pgpainless.org", null);
        String armored = PGPainless.asciiArmor((PGPKeyRing)secretKey);
        System.setIn(new ByteArrayInputStream(armored.getBytes(StandardCharsets.UTF_8)));
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        System.setOut(new PrintStream(out));
        PGPainlessCLI.execute((String[])new String[]{"dearmor"});
        Assertions.assertArrayEquals((byte[])secretKey.getEncoded(), (byte[])out.toByteArray());
    }

    @Test
    @FailOnSystemExit
    public void dearmorCertificate() throws PGPException, InvalidAlgorithmParameterException, NoSuchAlgorithmException, IOException {
        PGPSecretKeyRing secretKey = PGPainless.generateKeyRing().modernKeyRing("alice@pgpainless.org", null);
        PGPPublicKeyRing certificate = PGPainless.extractCertificate((PGPSecretKeyRing)secretKey);
        String armored = PGPainless.asciiArmor((PGPKeyRing)certificate);
        System.setIn(new ByteArrayInputStream(armored.getBytes(StandardCharsets.UTF_8)));
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        System.setOut(new PrintStream(out));
        PGPainlessCLI.execute((String[])new String[]{"dearmor"});
        Assertions.assertArrayEquals((byte[])certificate.getEncoded(), (byte[])out.toByteArray());
    }

    @Test
    @FailOnSystemExit
    public void dearmorMessage() {
        String armored = "-----BEGIN PGP MESSAGE-----\nVersion: BCPG v1.69\n\nSGVsbG8sIFdvcmxkCg==\n=fkLo\n-----END PGP MESSAGE-----";
        System.setIn(new ByteArrayInputStream(armored.getBytes(StandardCharsets.UTF_8)));
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        System.setOut(new PrintStream(out));
        PGPainlessCLI.execute((String[])new String[]{"dearmor"});
        Assertions.assertEquals((Object)"Hello, World\n", (Object)out.toString());
    }
}

