/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.encryption_signing;

import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import org.bouncycastle.openpgp.PGPSignature;
import org.pgpainless.algorithm.CompressionAlgorithm;
import org.pgpainless.algorithm.StreamEncoding;
import org.pgpainless.algorithm.SymmetricKeyAlgorithm;
import org.pgpainless.key.SubkeyIdentifier;
import org.pgpainless.util.MultiMap;

public final class EncryptionResult {
    private final SymmetricKeyAlgorithm encryptionAlgorithm;
    private final CompressionAlgorithm compressionAlgorithm;
    private final MultiMap<SubkeyIdentifier, PGPSignature> detachedSignatures;
    private final Set<SubkeyIdentifier> recipients;
    private final String fileName;
    private final Date modificationDate;
    private final StreamEncoding fileEncoding;

    private EncryptionResult(SymmetricKeyAlgorithm encryptionAlgorithm, CompressionAlgorithm compressionAlgorithm, MultiMap<SubkeyIdentifier, PGPSignature> detachedSignatures, Set<SubkeyIdentifier> recipients, String fileName, Date modificationDate, StreamEncoding encoding) {
        this.encryptionAlgorithm = encryptionAlgorithm;
        this.compressionAlgorithm = compressionAlgorithm;
        this.detachedSignatures = detachedSignatures;
        this.recipients = Collections.unmodifiableSet(recipients);
        this.fileName = fileName;
        this.modificationDate = modificationDate;
        this.fileEncoding = encoding;
    }

    @Deprecated
    public SymmetricKeyAlgorithm getSymmetricKeyAlgorithm() {
        return this.getEncryptionAlgorithm();
    }

    public SymmetricKeyAlgorithm getEncryptionAlgorithm() {
        return this.encryptionAlgorithm;
    }

    public CompressionAlgorithm getCompressionAlgorithm() {
        return this.compressionAlgorithm;
    }

    public MultiMap<SubkeyIdentifier, PGPSignature> getDetachedSignatures() {
        return this.detachedSignatures;
    }

    public Set<SubkeyIdentifier> getRecipients() {
        return this.recipients;
    }

    public String getFileName() {
        return this.fileName;
    }

    public Date getModificationDate() {
        return this.modificationDate;
    }

    public StreamEncoding getFileEncoding() {
        return this.fileEncoding;
    }

    public boolean isForYourEyesOnly() {
        return "_CONSOLE".equals(this.getFileName());
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private SymmetricKeyAlgorithm encryptionAlgorithm;
        private CompressionAlgorithm compressionAlgorithm;
        private final MultiMap<SubkeyIdentifier, PGPSignature> detachedSignatures = new MultiMap();
        private final Set<SubkeyIdentifier> recipients = new HashSet<SubkeyIdentifier>();
        private String fileName = "";
        private Date modificationDate = new Date(0L);
        private StreamEncoding encoding = StreamEncoding.BINARY;

        public Builder setEncryptionAlgorithm(SymmetricKeyAlgorithm encryptionAlgorithm) {
            this.encryptionAlgorithm = encryptionAlgorithm;
            return this;
        }

        public Builder setCompressionAlgorithm(CompressionAlgorithm compressionAlgorithm) {
            this.compressionAlgorithm = compressionAlgorithm;
            return this;
        }

        public Builder addRecipient(SubkeyIdentifier recipient) {
            this.recipients.add(recipient);
            return this;
        }

        public Builder addDetachedSignature(SubkeyIdentifier signingSubkeyIdentifier, PGPSignature detachedSignature) {
            this.detachedSignatures.put(signingSubkeyIdentifier, detachedSignature);
            return this;
        }

        public Builder setFileName(@Nonnull String fileName) {
            this.fileName = fileName;
            return this;
        }

        public Builder setModificationDate(@Nonnull Date modificationDate) {
            this.modificationDate = modificationDate;
            return this;
        }

        public Builder setFileEncoding(StreamEncoding fileEncoding) {
            this.encoding = fileEncoding;
            return this;
        }

        public EncryptionResult build() {
            if (this.encryptionAlgorithm == null) {
                throw new IllegalStateException("Encryption algorithm not set.");
            }
            if (this.compressionAlgorithm == null) {
                throw new IllegalStateException("Compression algorithm not set.");
            }
            return new EncryptionResult(this.encryptionAlgorithm, this.compressionAlgorithm, this.detachedSignatures, this.recipients, this.fileName, this.modificationDate, this.encoding);
        }
    }
}

