/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.key;

import java.net.URI;
import java.net.URISyntaxException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import javax.annotation.Nonnull;
import org.bouncycastle.openpgp.PGPKeyRing;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.bouncycastle.util.encoders.Hex;
import org.pgpainless.key.OpenPgpFingerprint;

public class OpenPgpV4Fingerprint
extends OpenPgpFingerprint {
    public static final String SCHEME = "openpgp4fpr";

    public OpenPgpV4Fingerprint(@Nonnull String fingerprint) {
        super(fingerprint);
    }

    @Override
    public int getVersion() {
        return 4;
    }

    @Override
    protected boolean isValid(@Nonnull String fp) {
        return fp.matches("[0-9A-F]{40}");
    }

    @Override
    public long getKeyId() {
        byte[] bytes = Hex.decode(this.toString().getBytes(utf8));
        ByteBuffer buf = ByteBuffer.wrap(bytes);
        ((Buffer)buf).position(12);
        return buf.getLong();
    }

    @Override
    public String prettyPrint() {
        int i;
        String fp = this.toString();
        StringBuilder pretty = new StringBuilder();
        for (i = 0; i < 5; ++i) {
            pretty.append(fp, i * 4, (i + 1) * 4).append(' ');
        }
        pretty.append(' ');
        for (i = 5; i < 9; ++i) {
            pretty.append(fp, i * 4, (i + 1) * 4).append(' ');
        }
        pretty.append(fp, 36, 40);
        return pretty.toString();
    }

    public OpenPgpV4Fingerprint(@Nonnull byte[] bytes) {
        super(Hex.encode(bytes));
    }

    public OpenPgpV4Fingerprint(@Nonnull PGPPublicKey key) {
        super(key);
    }

    public OpenPgpV4Fingerprint(@Nonnull PGPSecretKey key) {
        this(key.getPublicKey());
    }

    public OpenPgpV4Fingerprint(@Nonnull PGPPublicKeyRing ring) {
        super(ring);
    }

    public OpenPgpV4Fingerprint(@Nonnull PGPSecretKeyRing ring) {
        super(ring);
    }

    public OpenPgpV4Fingerprint(@Nonnull PGPKeyRing ring) {
        super(ring);
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (!(other instanceof CharSequence)) {
            return false;
        }
        return this.toString().equals(other.toString());
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public URI toUri() {
        try {
            return new URI(SCHEME, this.toString(), null);
        }
        catch (URISyntaxException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static OpenPgpV4Fingerprint fromUri(URI uri) {
        if (!SCHEME.equals(uri.getScheme())) {
            throw new IllegalArgumentException("URI scheme MUST equal 'openpgp4fpr'");
        }
        return new OpenPgpV4Fingerprint(uri.getSchemeSpecificPart());
    }

    @Override
    public int compareTo(@Nonnull OpenPgpFingerprint openPgpFingerprint) {
        return this.toString().compareTo(openPgpFingerprint.toString());
    }
}

