/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.algorithm;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public enum Feature {
    MODIFICATION_DETECTION(1),
    AEAD_ENCRYPTED_DATA(2),
    VERSION_5_PUBLIC_KEY(4);

    private static final Map<Byte, Feature> MAP;
    private final byte featureId;

    public static Feature fromId(byte id) {
        return MAP.get(id);
    }

    private Feature(byte featureId) {
        this.featureId = featureId;
    }

    public byte getFeatureId() {
        return this.featureId;
    }

    public static List<Feature> fromBitmask(int bitmask) {
        ArrayList<Feature> features = new ArrayList<Feature>();
        for (Feature f : Feature.values()) {
            if ((bitmask & f.featureId) == 0) continue;
            features.add(f);
        }
        return features;
    }

    public static byte toBitmask(Feature ... features) {
        byte mask = 0;
        for (Feature f : features) {
            mask = (byte)(mask | f.featureId);
        }
        return mask;
    }

    static {
        MAP = new ConcurrentHashMap<Byte, Feature>();
        for (Feature f : Feature.values()) {
            MAP.put(f.featureId, f);
        }
    }
}

