/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.cli.commands;

import com.ginsberg.junit.exit.FailOnSystemExit;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Arrays;
import org.bouncycastle.openpgp.PGPKeyRing;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.pgpainless.PGPainless;
import org.pgpainless.cli.PGPainlessCLI;
import org.pgpainless.cli.TestUtils;
import org.pgpainless.key.info.KeyRingInfo;

public class GenerateCertTest {
    @Test
    @FailOnSystemExit
    public void testKeyGeneration() throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        System.setOut(new PrintStream(out));
        PGPainlessCLI.execute((String[])new String[]{"generate-key", "--armor", "Juliet Capulet <juliet@capulet.lit>"});
        PGPSecretKeyRing secretKeys = PGPainless.readKeyRing().secretKeyRing(out.toByteArray());
        KeyRingInfo info = PGPainless.inspectKeyRing((PGPKeyRing)secretKeys);
        Assertions.assertTrue((boolean)info.isUserIdValid("Juliet Capulet <juliet@capulet.lit>"));
        byte[] outBegin = new byte[37];
        System.arraycopy(out.toByteArray(), 0, outBegin, 0, 37);
        Assertions.assertArrayEquals((byte[])outBegin, (byte[])TestUtils.ARMOR_PRIVATE_KEY_HEADER_BYTES);
    }

    @Test
    @FailOnSystemExit
    public void testNoArmor() {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        System.setOut(new PrintStream(out));
        PGPainlessCLI.execute((String[])new String[]{"generate-key", "--no-armor", "Test <test@test.test>"});
        byte[] outBegin = new byte[37];
        System.arraycopy(out.toByteArray(), 0, outBegin, 0, 37);
        Assertions.assertFalse((boolean)Arrays.equals(outBegin, TestUtils.ARMOR_PRIVATE_KEY_HEADER_BYTES));
    }
}

