/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.sop;

import java.io.IOException;
import java.io.InputStream;
import java.util.Locale;
import java.util.Properties;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import sop.operation.Version;

public class VersionImpl
implements Version {
    private static final String SOP_VERSION = "03";

    @Override
    public String getName() {
        return "PGPainless-SOP";
    }

    @Override
    public String getVersion() {
        String version;
        try {
            Properties properties = new Properties();
            InputStream propertiesFileIn = this.getClass().getResourceAsStream("/version.properties");
            if (propertiesFileIn == null) {
                throw new IOException("File version.properties not found.");
            }
            properties.load(propertiesFileIn);
            version = properties.getProperty("version");
        }
        catch (IOException e) {
            version = "DEVELOPMENT";
        }
        return version;
    }

    @Override
    public String getBackendVersion() {
        double bcVersion = new BouncyCastleProvider().getVersion();
        return String.format(Locale.US, "Bouncy Castle %.2f", bcVersion);
    }

    @Override
    public String getExtendedVersion() {
        return this.getName() + " " + this.getVersion() + "\nhttps://codeberg.org/PGPainless/pgpainless/src/branch/master/pgpainless-sop\n\nImplementation of the Stateless OpenPGP Protocol Version " + SOP_VERSION + "\nhttps://datatracker.ietf.org/doc/html/draft-dkg-openpgp-stateless-cli-" + SOP_VERSION + "\n\nBased on pgpainless-core " + this.getVersion() + "\nhttps://pgpainless.org\n\nUsing " + this.getBackendVersion() + "\nhttps://www.bouncycastle.org/java.html";
    }
}

