/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;

public final class DateUtil {
    private DateUtil() {
    }

    public static SimpleDateFormat getParser() {
        SimpleDateFormat parser = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss z");
        parser.setTimeZone(TimeZone.getTimeZone("UTC"));
        return parser;
    }

    public static Date parseUTCDate(String dateString) {
        try {
            return DateUtil.getParser().parse(dateString);
        }
        catch (ParseException e) {
            return null;
        }
    }

    public static String formatUTCDate(Date date) {
        return DateUtil.getParser().format(date);
    }

    public static Date toSecondsPrecision(Date date) {
        long millis = date.getTime();
        long seconds = millis / 1000L;
        long floored = seconds * 1000L;
        return new Date(floored);
    }

    public static Date now() {
        return DateUtil.toSecondsPrecision(new Date());
    }
}

