/*
 * Decompiled with CFR 0.152.
 */
package sop.operation;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Date;
import sop.DecryptionResult;
import sop.ReadyWithResult;
import sop.SessionKey;
import sop.exception.SOPGPException;

public interface Decrypt {
    public Decrypt verifyNotBefore(Date var1) throws SOPGPException.UnsupportedOption;

    public Decrypt verifyNotAfter(Date var1) throws SOPGPException.UnsupportedOption;

    public Decrypt verifyWithCert(InputStream var1) throws SOPGPException.BadData, SOPGPException.UnsupportedAsymmetricAlgo, IOException;

    default public Decrypt verifyWithCert(byte[] cert) throws SOPGPException.BadData, SOPGPException.UnsupportedAsymmetricAlgo, IOException {
        return this.verifyWithCert(new ByteArrayInputStream(cert));
    }

    public Decrypt withSessionKey(SessionKey var1) throws SOPGPException.UnsupportedOption;

    public Decrypt withPassword(String var1) throws SOPGPException.PasswordNotHumanReadable, SOPGPException.UnsupportedOption;

    public Decrypt withKey(InputStream var1) throws SOPGPException.BadData, SOPGPException.UnsupportedAsymmetricAlgo, IOException;

    default public Decrypt withKey(byte[] key) throws SOPGPException.BadData, SOPGPException.UnsupportedAsymmetricAlgo, IOException {
        return this.withKey(new ByteArrayInputStream(key));
    }

    default public Decrypt withKeyPassword(String password) throws SOPGPException.UnsupportedOption, SOPGPException.PasswordNotHumanReadable {
        return this.withKeyPassword(password.getBytes(Charset.forName("UTF8")));
    }

    public Decrypt withKeyPassword(byte[] var1) throws SOPGPException.UnsupportedOption, SOPGPException.PasswordNotHumanReadable;

    public ReadyWithResult<DecryptionResult> ciphertext(InputStream var1) throws SOPGPException.BadData, SOPGPException.MissingArg, SOPGPException.CannotDecrypt, SOPGPException.KeyIsProtected, IOException;

    default public ReadyWithResult<DecryptionResult> ciphertext(byte[] ciphertext) throws SOPGPException.BadData, SOPGPException.MissingArg, SOPGPException.CannotDecrypt, SOPGPException.KeyIsProtected, IOException {
        return this.ciphertext(new ByteArrayInputStream(ciphertext));
    }
}

