/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp.operator.jcajce;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.AlgorithmParameters;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPairGenerator;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Signature;
import javax.crypto.Cipher;
import javax.crypto.KeyAgreement;
import javax.crypto.SecretKey;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.jcajce.io.CipherInputStream;
import org.bouncycastle.jcajce.util.JcaJceHelper;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPUtil;
import org.bouncycastle.openpgp.operator.PGPDataDecryptor;
import org.bouncycastle.openpgp.operator.PGPDigestCalculator;
import org.bouncycastle.openpgp.operator.jcajce.SHA1PGPDigestCalculator;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.Exceptions;
import org.bouncycastle.util.Pack;
import org.bouncycastle.util.io.Streams;

class OperatorHelper {
    private JcaJceHelper helper;

    OperatorHelper(JcaJceHelper jcaJceHelper) {
        this.helper = jcaJceHelper;
    }

    String getDigestName(int n) throws PGPException {
        switch (n) {
            case 2: {
                return "SHA-1";
            }
            case 5: {
                return "MD2";
            }
            case 1: {
                return "MD5";
            }
            case 3: {
                return "RIPEMD160";
            }
            case 8: {
                return "SHA-256";
            }
            case 9: {
                return "SHA-384";
            }
            case 10: {
                return "SHA-512";
            }
            case 11: {
                return "SHA-224";
            }
            case 6: {
                return "TIGER";
            }
        }
        throw new PGPException("unknown hash algorithm tag in getDigestName: " + n);
    }

    MessageDigest createDigest(int n) throws GeneralSecurityException, PGPException {
        MessageDigest messageDigest;
        String string = this.getDigestName(n);
        try {
            messageDigest = this.helper.createMessageDigest(string);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            if (n >= 8 && n <= 11) {
                messageDigest = this.helper.createMessageDigest("SHA" + string.substring(4));
            }
            throw noSuchAlgorithmException;
        }
        return messageDigest;
    }

    KeyFactory createKeyFactory(String string) throws GeneralSecurityException, PGPException {
        return this.helper.createKeyFactory(string);
    }

    public KeyAgreement createKeyAgreement(String string) throws GeneralSecurityException {
        return this.helper.createKeyAgreement(string);
    }

    public KeyPairGenerator createKeyPairGenerator(String string) throws GeneralSecurityException {
        return this.helper.createKeyPairGenerator(string);
    }

    PGPDataDecryptor createDataDecryptor(boolean bl, int n, byte[] byArray) throws PGPException {
        try {
            SecretKeySpec secretKeySpec = new SecretKeySpec(byArray, PGPUtil.getSymmetricCipherName(n));
            final Cipher cipher = this.createStreamCipher(n, bl);
            if (bl) {
                byte[] byArray2 = new byte[cipher.getBlockSize()];
                cipher.init(2, (Key)secretKeySpec, new IvParameterSpec(byArray2));
            } else {
                cipher.init(2, secretKeySpec);
            }
            return new PGPDataDecryptor(){

                public InputStream getInputStream(InputStream inputStream) {
                    return new CipherInputStream(inputStream, cipher);
                }

                public int getBlockSize() {
                    return cipher.getBlockSize();
                }

                public PGPDigestCalculator getIntegrityCalculator() {
                    return new SHA1PGPDigestCalculator();
                }
            };
        }
        catch (PGPException pGPException) {
            throw pGPException;
        }
        catch (Exception exception) {
            throw new PGPException("Exception creating cipher", exception);
        }
    }

    Cipher createStreamCipher(int n, boolean bl) throws PGPException {
        String string = bl ? "CFB" : "OpenPGPCFB";
        String string2 = PGPUtil.getSymmetricCipherName(n) + "/" + string + "/NoPadding";
        return this.createCipher(string2);
    }

    static long getChunkLength(int n) {
        return 1L << n + 6;
    }

    static byte[] getNonce(byte[] byArray, long l) {
        byte[] byArray2 = Arrays.clone(byArray);
        OperatorHelper.xorChunkId(byArray2, l);
        return byArray2;
    }

    static void xorChunkId(byte[] byArray, long l) {
        int n = byArray.length - 8;
        int n2 = n++;
        byArray[n2] = (byte)(byArray[n2] ^ (byte)(l >> 56));
        int n3 = n++;
        byArray[n3] = (byte)(byArray[n3] ^ (byte)(l >> 48));
        int n4 = n++;
        byArray[n4] = (byte)(byArray[n4] ^ (byte)(l >> 40));
        int n5 = n++;
        byArray[n5] = (byte)(byArray[n5] ^ (byte)(l >> 32));
        int n6 = n++;
        byArray[n6] = (byte)(byArray[n6] ^ (byte)(l >> 24));
        int n7 = n++;
        byArray[n7] = (byte)(byArray[n7] ^ (byte)(l >> 16));
        int n8 = n++;
        byArray[n8] = (byte)(byArray[n8] ^ (byte)(l >> 8));
        int n9 = n;
        byArray[n9] = (byte)(byArray[n9] ^ (byte)l);
    }

    PGPDataDecryptor createDataDecryptor(final int n, final byte[] byArray, final int n2, final int n3, byte[] byArray2) throws PGPException {
        try {
            final SecretKeySpec secretKeySpec = new SecretKeySpec(byArray2, PGPUtil.getSymmetricCipherName(n3));
            final Cipher cipher = this.createAEADCipher(n3, n);
            return new PGPDataDecryptor(){

                public InputStream getInputStream(InputStream inputStream) {
                    try {
                        return new PGPAeadInputStream(inputStream, cipher, secretKeySpec, byArray, n3, n, n2);
                    }
                    catch (IOException iOException) {
                        throw Exceptions.illegalStateException("unable to open stream: " + iOException.getMessage(), iOException);
                    }
                }

                public int getBlockSize() {
                    return cipher.getBlockSize();
                }

                public PGPDigestCalculator getIntegrityCalculator() {
                    return new SHA1PGPDigestCalculator();
                }
            };
        }
        catch (PGPException pGPException) {
            throw pGPException;
        }
        catch (Exception exception) {
            throw new PGPException("Exception creating cipher", exception);
        }
    }

    Cipher createAEADCipher(int n, int n2) throws PGPException {
        String string;
        switch (n2) {
            case 1: {
                string = "EAX";
                break;
            }
            case 2: {
                string = "OCB";
                break;
            }
            case 3: {
                string = "GCM";
                break;
            }
            default: {
                throw new PGPException("encountered unknown AEAD algorithm: " + n2);
            }
        }
        String string2 = PGPUtil.getSymmetricCipherName(n) + "/" + string + "/NoPadding";
        return this.createCipher(string2);
    }

    Cipher createCipher(String string) throws PGPException {
        try {
            return this.helper.createCipher(string);
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new PGPException("cannot create cipher: " + generalSecurityException.getMessage(), generalSecurityException);
        }
    }

    Cipher createPublicKeyCipher(int n) throws PGPException {
        switch (n) {
            case 1: 
            case 2: {
                return this.createCipher("RSA/ECB/PKCS1Padding");
            }
            case 16: 
            case 20: {
                return this.createCipher("ElGamal/ECB/PKCS1Padding");
            }
            case 17: {
                throw new PGPException("Can't use DSA for encryption.");
            }
            case 19: {
                throw new PGPException("Can't use ECDSA for encryption.");
            }
            case 22: {
                throw new PGPException("Can't use EDDSA for encryption.");
            }
        }
        throw new PGPException("unknown asymmetric algorithm: " + n);
    }

    Cipher createKeyWrapper(int n) throws PGPException {
        try {
            switch (n) {
                case 7: 
                case 8: 
                case 9: {
                    return this.helper.createCipher("AESWrap");
                }
                case 11: 
                case 12: 
                case 13: {
                    return this.helper.createCipher("CamelliaWrap");
                }
            }
            throw new PGPException("unknown wrap algorithm: " + n);
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new PGPException("cannot create cipher: " + generalSecurityException.getMessage(), generalSecurityException);
        }
    }

    private Signature createSignature(String string) throws PGPException {
        try {
            return this.helper.createSignature(string);
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new PGPException("cannot create signature: " + generalSecurityException.getMessage(), generalSecurityException);
        }
    }

    public Signature createSignature(int n, int n2) throws PGPException {
        String string;
        switch (n) {
            case 1: 
            case 3: {
                string = "RSA";
                break;
            }
            case 17: {
                string = "DSA";
                break;
            }
            case 16: 
            case 20: {
                string = "ElGamal";
                break;
            }
            case 19: {
                string = "ECDSA";
                break;
            }
            case 22: {
                return this.createSignature("Ed25519");
            }
            default: {
                throw new PGPException("unknown algorithm tag in signature:" + n);
            }
        }
        return this.createSignature(PGPUtil.getDigestName(n2) + "with" + string);
    }

    public AlgorithmParameters createAlgorithmParameters(String string) throws NoSuchProviderException, NoSuchAlgorithmException {
        return this.helper.createAlgorithmParameters(string);
    }

    private static class PGPAeadInputStream
    extends InputStream {
        private final InputStream in;
        private final byte[] buf;
        private final Cipher c;
        private final SecretKey secretKey;
        private final byte[] aaData;
        private final byte[] iv;
        private final int chunkLength;
        private byte[] data;
        private int dataOff;
        private long chunkIndex = 0L;
        private long totalBytes = 0L;

        public PGPAeadInputStream(InputStream inputStream, Cipher cipher, SecretKey secretKey, byte[] byArray, int n, int n2, int n3) throws IOException {
            this.in = inputStream;
            this.iv = byArray;
            this.chunkLength = (int)OperatorHelper.getChunkLength(n3);
            this.buf = new byte[this.chunkLength + 32];
            this.c = cipher;
            this.secretKey = secretKey;
            this.aaData = new byte[5];
            this.aaData[0] = -44;
            this.aaData[1] = 1;
            this.aaData[2] = (byte)n;
            this.aaData[3] = (byte)n2;
            this.aaData[4] = (byte)n3;
            Streams.readFully(inputStream, this.buf, 0, 32);
            this.data = this.readBlock();
            this.dataOff = 0;
        }

        public int read() throws IOException {
            if (this.data != null && this.dataOff == this.data.length) {
                this.data = this.readBlock();
                this.dataOff = 0;
            }
            if (this.data == null) {
                return -1;
            }
            return this.data[this.dataOff++] & 0xFF;
        }

        public int read(byte[] byArray, int n, int n2) throws IOException {
            if (this.data != null && this.dataOff == this.data.length) {
                this.data = this.readBlock();
                this.dataOff = 0;
            }
            if (this.data == null) {
                return -1;
            }
            int n3 = Math.min(n2, this.available());
            System.arraycopy(this.data, this.dataOff, byArray, n, n3);
            this.dataOff += n3;
            return n3;
        }

        public long skip(long l) throws IOException {
            if (l <= 0L) {
                return 0L;
            }
            int n = (int)Math.min(l, (long)this.available());
            this.dataOff += n;
            return n;
        }

        public int available() throws IOException {
            if (this.data != null && this.dataOff == this.data.length) {
                this.data = this.readBlock();
                this.dataOff = 0;
            }
            if (this.data == null) {
                return -1;
            }
            return this.data.length - this.dataOff;
        }

        private byte[] readBlock() throws IOException {
            byte[] byArray;
            int n = Streams.readFully(this.in, this.buf, 32, this.chunkLength);
            if (n == 0) {
                return null;
            }
            byte[] byArray2 = new byte[13];
            System.arraycopy(this.aaData, 0, byArray2, 0, this.aaData.length);
            OperatorHelper.xorChunkId(byArray2, this.chunkIndex);
            try {
                this.c.init(2, (Key)this.secretKey, new GCMParameterSpec(128, OperatorHelper.getNonce(this.iv, this.chunkIndex)));
                this.c.updateAAD(byArray2);
                byArray = this.c.doFinal(this.buf, 0, n + 16);
            }
            catch (GeneralSecurityException generalSecurityException) {
                throw new IOException("exception processing chunk " + this.chunkIndex + ": " + generalSecurityException.getMessage());
            }
            this.totalBytes += (long)byArray.length;
            ++this.chunkIndex;
            System.arraycopy(this.buf, n + 16, this.buf, 0, 16);
            if (n != this.chunkLength) {
                byArray2 = new byte[13];
                System.arraycopy(this.aaData, 0, byArray2, 0, this.aaData.length);
                OperatorHelper.xorChunkId(byArray2, this.chunkIndex);
                try {
                    this.c.init(2, (Key)this.secretKey, new GCMParameterSpec(128, OperatorHelper.getNonce(this.iv, this.chunkIndex)));
                    this.c.updateAAD(byArray2);
                    this.c.updateAAD(Pack.longToBigEndian(this.totalBytes));
                    this.c.doFinal(this.buf, 0, 16);
                }
                catch (GeneralSecurityException generalSecurityException) {
                    throw new IOException("exception processing final tag: " + generalSecurityException.getMessage());
                }
            } else {
                Streams.readFully(this.in, this.buf, 16, 16);
            }
            return byArray;
        }
    }

    static class PGPAeadOutputStream
    extends OutputStream {
        private final OutputStream out;
        private final byte[] data;
        private final Cipher c;
        private final SecretKey secretKey;
        private final byte[] aaData;
        private final byte[] iv;
        private final int chunkLength;
        private int dataOff;
        private long chunkIndex = 0L;
        private long totalBytes = 0L;

        public PGPAeadOutputStream(OutputStream outputStream, Cipher cipher, SecretKey secretKey, int n, int n2, int n3, byte[] byArray) {
            this.out = outputStream;
            this.iv = byArray;
            this.chunkLength = (int)OperatorHelper.getChunkLength(n3);
            this.data = new byte[this.chunkLength];
            this.c = cipher;
            this.secretKey = secretKey;
            this.aaData = new byte[5];
            this.aaData[0] = -44;
            this.aaData[1] = 1;
            this.aaData[2] = (byte)n;
            this.aaData[3] = (byte)n2;
            this.aaData[4] = (byte)n3;
        }

        public void write(int n) throws IOException {
            if (this.dataOff == this.data.length) {
                this.writeBlock();
            }
            this.data[this.dataOff++] = (byte)n;
        }

        public void write(byte[] byArray, int n, int n2) throws IOException {
            if (this.dataOff == this.data.length) {
                this.writeBlock();
            }
            if (n2 < this.data.length - this.dataOff) {
                System.arraycopy(byArray, n, this.data, this.dataOff, n2);
                this.dataOff += n2;
            } else {
                int n3 = this.data.length - this.dataOff;
                System.arraycopy(byArray, n, this.data, this.dataOff, n3);
                this.dataOff += n3;
                this.writeBlock();
                n2 -= n3;
                n += n3;
                while (n2 >= this.data.length) {
                    System.arraycopy(byArray, n, this.data, 0, this.data.length);
                    this.dataOff = this.data.length;
                    this.writeBlock();
                    n2 -= this.data.length;
                    n += this.data.length;
                }
                if (n2 > 0) {
                    System.arraycopy(byArray, n, this.data, 0, n2);
                    this.dataOff = n2;
                }
            }
        }

        public void close() throws IOException {
            this.finish();
        }

        private void writeBlock() throws IOException {
            byte[] byArray = new byte[13];
            System.arraycopy(this.aaData, 0, byArray, 0, this.aaData.length);
            OperatorHelper.xorChunkId(byArray, this.chunkIndex);
            try {
                this.c.init(1, (Key)this.secretKey, new GCMParameterSpec(128, OperatorHelper.getNonce(this.iv, this.chunkIndex)));
                this.c.updateAAD(byArray);
                this.out.write(this.c.doFinal(this.data, 0, this.dataOff));
            }
            catch (GeneralSecurityException generalSecurityException) {
                throw new IOException("exception processing chunk " + this.chunkIndex + ": " + generalSecurityException.getMessage());
            }
            this.totalBytes += (long)this.dataOff;
            ++this.chunkIndex;
            this.dataOff = 0;
        }

        private void finish() throws IOException {
            if (this.dataOff > 0) {
                this.writeBlock();
            }
            byte[] byArray = new byte[13];
            System.arraycopy(this.aaData, 0, byArray, 0, this.aaData.length);
            OperatorHelper.xorChunkId(byArray, this.chunkIndex);
            try {
                this.c.init(1, (Key)this.secretKey, new GCMParameterSpec(128, OperatorHelper.getNonce(this.iv, this.chunkIndex)));
                this.c.updateAAD(byArray);
                this.c.updateAAD(Pack.longToBigEndian(this.totalBytes));
                this.out.write(this.c.doFinal(this.aaData, 0, 0));
            }
            catch (GeneralSecurityException generalSecurityException) {
                throw new IOException("exception processing final tag: " + generalSecurityException.getMessage());
            }
        }
    }
}

