/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.key;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import javax.annotation.Nonnull;
import org.bouncycastle.openpgp.PGPKeyRing;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.bouncycastle.util.encoders.Hex;
import org.pgpainless.key.OpenPgpFingerprint;

public class OpenPgpV5Fingerprint
extends OpenPgpFingerprint {
    public OpenPgpV5Fingerprint(@Nonnull String fingerprint) {
        super(fingerprint);
    }

    public OpenPgpV5Fingerprint(@Nonnull byte[] bytes) {
        super(Hex.encode(bytes));
    }

    public OpenPgpV5Fingerprint(@Nonnull PGPPublicKey key) {
        super(key);
    }

    public OpenPgpV5Fingerprint(@Nonnull PGPSecretKey key) {
        this(key.getPublicKey());
    }

    public OpenPgpV5Fingerprint(@Nonnull PGPPublicKeyRing ring) {
        super(ring);
    }

    public OpenPgpV5Fingerprint(@Nonnull PGPSecretKeyRing ring) {
        super(ring);
    }

    public OpenPgpV5Fingerprint(@Nonnull PGPKeyRing ring) {
        super(ring);
    }

    @Override
    public int getVersion() {
        return 5;
    }

    @Override
    protected boolean isValid(@Nonnull String fp) {
        return fp.matches("^[0-9A-F]{64}$");
    }

    @Override
    public long getKeyId() {
        byte[] bytes = Hex.decode(this.toString().getBytes(utf8));
        ByteBuffer buf = ByteBuffer.wrap(bytes);
        ((Buffer)buf).position(0);
        return buf.getLong();
    }

    @Override
    public String prettyPrint() {
        int i;
        String fp = this.toString();
        StringBuilder pretty = new StringBuilder();
        for (i = 0; i < 4; ++i) {
            pretty.append(fp, i * 8, (i + 1) * 8).append(' ');
        }
        pretty.append(' ');
        for (i = 4; i < 7; ++i) {
            pretty.append(fp, i * 8, (i + 1) * 8).append(' ');
        }
        pretty.append(fp, 56, 64);
        return pretty.toString();
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (!(other instanceof CharSequence)) {
            return false;
        }
        return this.toString().equals(other.toString());
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    @Override
    public int compareTo(OpenPgpFingerprint openPgpFingerprint) {
        return this.toString().compareTo(openPgpFingerprint.toString());
    }
}

