/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.cli.commands;

import com.ginsberg.junit.exit.FailOnSystemExit;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.pgpainless.PGPainless;
import org.pgpainless.algorithm.KeyFlag;
import org.pgpainless.cli.commands.CLITest;
import org.pgpainless.key.generation.KeyRingBuilder;
import org.pgpainless.key.generation.KeySpec;
import org.pgpainless.key.generation.type.KeyType;
import org.pgpainless.key.generation.type.eddsa.EdDSACurve;
import org.pgpainless.key.generation.type.xdh.XDHSpec;
import org.slf4j.LoggerFactory;

public class RoundTripEncryptDecryptCmdTest
extends CLITest {
    private static final String KEY = "-----BEGIN PGP PRIVATE KEY BLOCK-----\nVersion: PGPainless\nComment: A2EC 077F C977 E15D D799  EFF9 2C0D 3C12 3CF5 1C08\nComment: Alice <alice@pgpainless.org>\n\nlFgEY2veRhYJKwYBBAHaRw8BAQdAeJYBoCcnGPQ3nchyyBrWQ83q3hqJnfZn2mqh\nd1M7WwsAAP0R1ELnfdJhXcfjaYPLHzwy1i34FxP5g3tvdgg9Q7VmchActBxBbGlj\nZSA8YWxpY2VAcGdwYWlubGVzcy5vcmc+iI8EExYKAEEFAmNr3kYJECwNPBI89RwI\nFiEEouwHf8l34V3Xme/5LA08Ejz1HAgCngECmwEFFgIDAQAECwkIBwUVCgkICwKZ\nAQAAe6YA/2sO483Vi2Fgs4ejv8FykyO96IVrMoYhw3Od4LyWEyDfAQDi15LxJJm6\nT2sXdENVigdwDJiELxjOtbmivuJutxkWCJxdBGNr3kYSCisGAQQBl1UBBQEBB0CS\nzXjySHqlicxG3QlrVeTIqwKitL1sWsx0MCDmT1C8dAMBCAcAAP9VNkfMQvYAlYSP\naYEkwEOc8/XpiloVKtPzxwVCPlXFeBDCiHUEGBYKAB0FAmNr3kYCngECmwwFFgID\nAQAECwkIBwUVCgkICwAKCRAsDTwSPPUcCOT4AQDZcN5a/e8Qr+LNBIyXXLgJWGsL\n59nsKHBbDURnxbEnMQEAybS8u+Rsb82yW4CfaA4CLRTC3eDc5Y4QwYWzLogWNwic\nWARja95GFgkrBgEEAdpHDwEBB0DcdwQufWLq6ASku4JWBBd9JplRVhK0cXWuTE73\nuWltuwABAI0bVQXvgDnxTs6kUO7JIWtokM5lI/1bfG4L1YOfnXIgD7CI1QQYFgoA\nfQUCY2veRgKeAQKbAgUWAgMBAAQLCQgHBRUKCQgLXyAEGRYKAAYFAmNr3kYACgkQ\n7NC/hj9lyaWVAwEA3ze1LCi1reGfB5tS3Au6A8aalyk4UV0iVOXxwV5r+E4BAJGz\nZMFF/iQ/rOcSAsHPp4ggezZALDIkT2Hrn6iLDdsLAAoJECwNPBI89RwIuBIBAMxG\nu/s4maOFozcO4JoCZTsLHGy70SG6UuVQjK0EyJJ1APoDEfK+qTlC7/FoijMA6Ew9\naesZ2IHgpwA7jlyHSgwLDw==\n=H3HU\n-----END PGP PRIVATE KEY BLOCK-----";
    private static final String CERT = "-----BEGIN PGP PUBLIC KEY BLOCK-----\nVersion: PGPainless\nComment: A2EC 077F C977 E15D D799  EFF9 2C0D 3C12 3CF5 1C08\nComment: Alice <alice@pgpainless.org>\n\nmDMEY2veRhYJKwYBBAHaRw8BAQdAeJYBoCcnGPQ3nchyyBrWQ83q3hqJnfZn2mqh\nd1M7Wwu0HEFsaWNlIDxhbGljZUBwZ3BhaW5sZXNzLm9yZz6IjwQTFgoAQQUCY2ve\nRgkQLA08Ejz1HAgWIQSi7Ad/yXfhXdeZ7/ksDTwSPPUcCAKeAQKbAQUWAgMBAAQL\nCQgHBRUKCQgLApkBAAB7pgD/aw7jzdWLYWCzh6O/wXKTI73ohWsyhiHDc53gvJYT\nIN8BAOLXkvEkmbpPaxd0Q1WKB3AMmIQvGM61uaK+4m63GRYIuDgEY2veRhIKKwYB\nBAGXVQEFAQEHQJLNePJIeqWJzEbdCWtV5MirAqK0vWxazHQwIOZPULx0AwEIB4h1\nBBgWCgAdBQJja95GAp4BApsMBRYCAwEABAsJCAcFFQoJCAsACgkQLA08Ejz1HAjk\n+AEA2XDeWv3vEK/izQSMl1y4CVhrC+fZ7ChwWw1EZ8WxJzEBAMm0vLvkbG/NsluA\nn2gOAi0Uwt3g3OWOEMGFsy6IFjcIuDMEY2veRhYJKwYBBAHaRw8BAQdA3HcELn1i\n6ugEpLuCVgQXfSaZUVYStHF1rkxO97lpbbuI1QQYFgoAfQUCY2veRgKeAQKbAgUW\nAgMBAAQLCQgHBRUKCQgLXyAEGRYKAAYFAmNr3kYACgkQ7NC/hj9lyaWVAwEA3ze1\nLCi1reGfB5tS3Au6A8aalyk4UV0iVOXxwV5r+E4BAJGzZMFF/iQ/rOcSAsHPp4gg\nezZALDIkT2Hrn6iLDdsLAAoJECwNPBI89RwIuBIBAMxGu/s4maOFozcO4JoCZTsL\nHGy70SG6UuVQjK0EyJJ1APoDEfK+qTlC7/FoijMA6Ew9aesZ2IHgpwA7jlyHSgwL\nDw==\n=c1PZ\n-----END PGP PUBLIC KEY BLOCK-----";

    public RoundTripEncryptDecryptCmdTest() {
        super(LoggerFactory.getLogger(RoundTripEncryptDecryptCmdTest.class));
    }

    @Test
    @FailOnSystemExit
    public void encryptAndDecryptAMessage() throws IOException {
        File julietKeyFile = this.pipeStdoutToFile("juliet.key");
        this.assertSuccess(this.executeCommand("generate-key", "Juliet <juliet@capulet.lit>"));
        this.pipeFileToStdin(julietKeyFile);
        File julietCertFile = this.pipeStdoutToFile("juliet.cert");
        this.assertSuccess(this.executeCommand("extract-cert"));
        File romeoKeyFile = this.pipeStdoutToFile("romeo.key");
        this.assertSuccess(this.executeCommand("generate-key", "Romeo <romeo@montague.lit>"));
        File romeoCertFile = this.pipeStdoutToFile("romeo.cert");
        this.pipeFileToStdin(romeoKeyFile);
        this.assertSuccess(this.executeCommand("extract-cert"));
        String msg = "Hello World!\n";
        File encryptedMessageFile = this.pipeStdoutToFile("msg.asc");
        this.pipeStringToStdin(msg);
        this.assertSuccess(this.executeCommand("encrypt", "--sign-with", romeoKeyFile.getAbsolutePath(), julietCertFile.getAbsolutePath(), romeoCertFile.getAbsolutePath()));
        this.pipeFileToStdin(encryptedMessageFile);
        File verificationsFile = this.nonExistentFile("verifications");
        ByteArrayOutputStream decrypted = this.pipeStdoutToStream();
        this.assertSuccess(this.executeCommand("decrypt", "--verifications-out", verificationsFile.getAbsolutePath(), "--verify-with", romeoCertFile.getAbsolutePath(), julietKeyFile.getAbsolutePath()));
        Assertions.assertEquals((Object)msg, (Object)decrypted.toString());
        this.pipeFileToStdin(encryptedMessageFile);
        File anotherVerificationsFile = this.nonExistentFile("anotherVerifications");
        decrypted = this.pipeStdoutToStream();
        this.assertSuccess(this.executeCommand("decrypt", "--verifications-out", anotherVerificationsFile.getAbsolutePath(), "--verify-with", romeoCertFile.getAbsolutePath(), romeoKeyFile.getAbsolutePath()));
        Assertions.assertEquals((Object)msg, (Object)decrypted.toString());
        String julietsVerif = this.readStringFromFile(verificationsFile);
        String romeosVerif = this.readStringFromFile(anotherVerificationsFile);
        Assertions.assertEquals((Object)julietsVerif, (Object)romeosVerif);
        Assertions.assertFalse((boolean)julietsVerif.isEmpty());
        Assertions.assertEquals((int)103, (int)julietsVerif.length());
    }

    @Test
    public void testMissingArgumentsIfNoArgsSupplied() throws IOException {
        int exit = this.executeCommand("encrypt");
        Assertions.assertEquals((int)19, (int)exit);
    }

    @Test
    public void testEncryptingForKeyFails() throws IOException {
        File notACert = this.writeFile("key.asc", KEY);
        this.pipeStringToStdin("Hello, World!");
        ByteArrayOutputStream out = this.pipeStdoutToStream();
        int exitCode = this.executeCommand("encrypt", notACert.getAbsolutePath());
        Assertions.assertEquals((int)41, (int)exitCode);
        Assertions.assertEquals((int)0, (int)out.size());
    }

    @Test
    public void testEncrypt_SignWithCertFails() throws IOException {
        File cert;
        File notAKey = cert = this.writeFile("cert.asc", CERT);
        this.pipeStringToStdin("Hello, World!");
        ByteArrayOutputStream out = this.pipeStdoutToStream();
        int exitCode = this.executeCommand("encrypt", "--sign-with", notAKey.getAbsolutePath(), cert.getAbsolutePath());
        Assertions.assertEquals((int)41, (int)exitCode);
        Assertions.assertEquals((int)0, (int)out.size());
    }

    @Test
    public void testDecryptVerifyOut_withoutVerifyWithFails() throws IOException {
        File key = this.writeFile("key.asc", KEY);
        File verifications = this.nonExistentFile("verifications");
        ByteArrayOutputStream out = this.pipeStdoutToStream();
        int exitCode = this.executeCommand("decrypt", "--verifications-out", verifications.getAbsolutePath(), key.getAbsolutePath());
        Assertions.assertEquals((int)23, (int)exitCode);
        Assertions.assertEquals((int)0, (int)out.size());
    }

    @Test
    public void testVerificationsOutAlreadyExistFails() throws IOException {
        File key = this.writeFile("key.asc", KEY);
        File cert = this.writeFile("cert.asc", CERT);
        File verifications = this.writeFile("verifications", "this file is not empty");
        ByteArrayOutputStream out = this.pipeStdoutToStream();
        int exitCode = this.executeCommand("decrypt", "--verify-with", cert.getAbsolutePath(), "--verifications-out", verifications.getAbsolutePath(), key.getAbsolutePath());
        Assertions.assertEquals((int)59, (int)exitCode);
        Assertions.assertEquals((int)0, (int)out.size());
    }

    @Test
    public void testSessionKeyOutWritesSessionKeyOut() throws IOException {
        File key = this.writeFile("key.asc", KEY);
        File sessionKeyFile = this.nonExistentFile("session.key");
        String plaintext = "Hello, World!\n";
        String ciphertext = "-----BEGIN PGP MESSAGE-----\nVersion: PGPainless\n\nhF4D831k4umlLu4SAQdAYisjZTDRm217LHQbqjB766tm62CKTkRj3Gd0wYxVRCgw\n48SnOJINCJoPgDsxk2NiJmLCImoiET7IElqxN9htdDXQJwcRK+71r/ZyO4YJpWuX\n0sAAAcEFc3nT+un31sOi8KoBJlc5n+MemntQvcWDs8B87BEW/Ncjrs0s4pJpZKBQ\n/AWc4wLCI3ylfMQJB2pICqaOO3KP3WepgTIw5fuZm6YfriKQi7uZvVx1N+uaCIoa\nK2IVVf/7O9KZJ9GbsGYdpBj9IdaIZiVS3Xi8rwgQl3haI/EeHC3nnCsWyj23Fjt3\nLjbMqpHbSnp8U1cQ8rXavrREaKv69PFeJio6/hRg32TzJqn05dPALRxHMEkxxa4h\nFpVU\n=edS5\n-----END PGP MESSAGE-----";
        String sessionKey = "9:B6FAD96B7ED2DA27D8A36EAEA75DAB7AC587180B14D8A24BD7263524F3DDECC3\n";
        this.pipeStringToStdin(ciphertext);
        ByteArrayOutputStream plaintextOut = this.pipeStdoutToStream();
        this.assertSuccess(this.executeCommand("decrypt", "--session-key-out", sessionKeyFile.getAbsolutePath(), key.getAbsolutePath()));
        Assertions.assertEquals((Object)plaintext, (Object)plaintextOut.toString());
        String resultSessionKey = this.readStringFromFile(sessionKeyFile);
        Assertions.assertEquals((Object)sessionKey, (Object)resultSessionKey);
    }

    @Test
    public void decryptMessageWithSessionKey() throws IOException {
        String plaintext = "Hello, World!\n";
        String ciphertext = "-----BEGIN PGP MESSAGE-----\nVersion: PGPainless\n\nhF4D831k4umlLu4SAQdAYisjZTDRm217LHQbqjB766tm62CKTkRj3Gd0wYxVRCgw\n48SnOJINCJoPgDsxk2NiJmLCImoiET7IElqxN9htdDXQJwcRK+71r/ZyO4YJpWuX\n0sAAAcEFc3nT+un31sOi8KoBJlc5n+MemntQvcWDs8B87BEW/Ncjrs0s4pJpZKBQ\n/AWc4wLCI3ylfMQJB2pICqaOO3KP3WepgTIw5fuZm6YfriKQi7uZvVx1N+uaCIoa\nK2IVVf/7O9KZJ9GbsGYdpBj9IdaIZiVS3Xi8rwgQl3haI/EeHC3nnCsWyj23Fjt3\nLjbMqpHbSnp8U1cQ8rXavrREaKv69PFeJio6/hRg32TzJqn05dPALRxHMEkxxa4h\nFpVU\n=edS5\n-----END PGP MESSAGE-----";
        String sessionKey = "9:B6FAD96B7ED2DA27D8A36EAEA75DAB7AC587180B14D8A24BD7263524F3DDECC3\n";
        File sessionKeyFile = this.writeFile("session.key", sessionKey);
        this.pipeStringToStdin(ciphertext);
        ByteArrayOutputStream plaintextOut = this.pipeStdoutToStream();
        this.assertSuccess(this.executeCommand("decrypt", "--with-session-key", sessionKeyFile.getAbsolutePath()));
        Assertions.assertEquals((Object)plaintext, (Object)plaintextOut.toString());
    }

    @Test
    public void testDecryptWithSessionKeyVerifyWithYieldsExpectedVerifications() throws IOException {
        String plaintext = "Hello, World!\n";
        String ciphertext = "-----BEGIN PGP MESSAGE-----\nVersion: PGPainless\n\nhF4D831k4umlLu4SAQdAYisjZTDRm217LHQbqjB766tm62CKTkRj3Gd0wYxVRCgw\n48SnOJINCJoPgDsxk2NiJmLCImoiET7IElqxN9htdDXQJwcRK+71r/ZyO4YJpWuX\n0sAAAcEFc3nT+un31sOi8KoBJlc5n+MemntQvcWDs8B87BEW/Ncjrs0s4pJpZKBQ\n/AWc4wLCI3ylfMQJB2pICqaOO3KP3WepgTIw5fuZm6YfriKQi7uZvVx1N+uaCIoa\nK2IVVf/7O9KZJ9GbsGYdpBj9IdaIZiVS3Xi8rwgQl3haI/EeHC3nnCsWyj23Fjt3\nLjbMqpHbSnp8U1cQ8rXavrREaKv69PFeJio6/hRg32TzJqn05dPALRxHMEkxxa4h\nFpVU\n=edS5\n-----END PGP MESSAGE-----";
        String sessionKey = "9:B6FAD96B7ED2DA27D8A36EAEA75DAB7AC587180B14D8A24BD7263524F3DDECC3\n";
        File cert = this.writeFile("cert.asc", CERT);
        File sessionKeyFile = this.writeFile("session.key", sessionKey);
        File verifications = this.nonExistentFile("verifications");
        this.pipeStringToStdin(ciphertext);
        ByteArrayOutputStream out = this.pipeStdoutToStream();
        this.assertSuccess(this.executeCommand("decrypt", "--with-session-key", sessionKeyFile.getAbsolutePath(), "--verify-with", cert.getAbsolutePath(), "--verifications-out", verifications.getAbsolutePath()));
        Assertions.assertEquals((Object)plaintext, (Object)out.toString());
        String verificationString = this.readStringFromFile(verifications);
        Assertions.assertEquals((Object)"2022-11-09T17:22:48Z C0DCEC44B1A173664B05DABCECD0BF863F65C9A5 A2EC077FC977E15DD799EFF92C0D3C123CF51C08\n", (Object)verificationString);
    }

    @Test
    public void encryptAndDecryptMessageWithPassphrase() throws IOException {
        File passwordFile = this.writeFile("password", "c1tiz\u20acn4");
        String message = "I cannot think of meaningful messages for test vectors rn";
        this.pipeStringToStdin(message);
        ByteArrayOutputStream ciphertext = this.pipeStdoutToStream();
        this.assertSuccess(this.executeCommand("encrypt", "--with-password", passwordFile.getAbsolutePath()));
        String ciphertextString = ciphertext.toString();
        Assertions.assertTrue((boolean)ciphertextString.startsWith("-----BEGIN PGP MESSAGE-----\n"));
        this.pipeBytesToStdin(ciphertext.toByteArray());
        ByteArrayOutputStream plaintext = this.pipeStdoutToStream();
        this.assertSuccess(this.executeCommand("decrypt", "--with-password", passwordFile.getAbsolutePath()));
        Assertions.assertEquals((Object)message, (Object)plaintext.toString());
    }

    @Test
    public void testEncryptWithIncapableCert() throws PGPException, InvalidAlgorithmParameterException, NoSuchAlgorithmException, IOException {
        PGPSecretKeyRing secretKeys = ((KeyRingBuilder)PGPainless.buildKeyRing().addUserId("No Crypt <no@crypt.key>").setPrimaryKey(KeySpec.getBuilder((KeyType)KeyType.EDDSA((EdDSACurve)EdDSACurve._Ed25519), (KeyFlag)KeyFlag.CERTIFY_OTHER, (KeyFlag[])new KeyFlag[]{KeyFlag.SIGN_DATA}))).build();
        PGPPublicKeyRing cert = PGPainless.extractCertificate((PGPSecretKeyRing)secretKeys);
        File certFile = this.writeFile("cert.pgp", cert.getEncoded());
        this.pipeStringToStdin("Hello, World!\n");
        ByteArrayOutputStream out = this.pipeStdoutToStream();
        int exitCode = this.executeCommand("encrypt", certFile.getAbsolutePath());
        Assertions.assertEquals((int)17, (int)exitCode);
        Assertions.assertEquals((int)0, (int)out.size());
    }

    @Test
    public void testSignWithIncapableKey() throws IOException, PGPException, InvalidAlgorithmParameterException, NoSuchAlgorithmException {
        PGPSecretKeyRing secretKeys = ((KeyRingBuilder)((KeyRingBuilder)PGPainless.buildKeyRing().addUserId("Cannot Sign <cannot@sign.key>").setPrimaryKey(KeySpec.getBuilder((KeyType)KeyType.EDDSA((EdDSACurve)EdDSACurve._Ed25519), (KeyFlag)KeyFlag.CERTIFY_OTHER, (KeyFlag[])new KeyFlag[0]))).addSubkey(KeySpec.getBuilder((KeyType)KeyType.XDH((XDHSpec)XDHSpec._X25519), (KeyFlag)KeyFlag.ENCRYPT_COMMS, (KeyFlag[])new KeyFlag[]{KeyFlag.ENCRYPT_STORAGE}))).build();
        File keyFile = this.writeFile("key.pgp", secretKeys.getEncoded());
        File certFile = this.writeFile("cert.pgp", PGPainless.extractCertificate((PGPSecretKeyRing)secretKeys).getEncoded());
        this.pipeStringToStdin("Hello, World!\n");
        ByteArrayOutputStream out = this.pipeStdoutToStream();
        int exitCode = this.executeCommand("encrypt", "--sign-with", keyFile.getAbsolutePath(), certFile.getAbsolutePath());
        Assertions.assertEquals((int)79, (int)exitCode);
        Assertions.assertEquals((int)0, (int)out.size());
    }

    @Test
    public void testEncryptDecryptRoundTripWithPasswordProtectedKey() throws IOException {
        File passwordFile = this.writeFile("password", "fooBarBaz420");
        File keyFile = this.pipeStdoutToFile("key.asc");
        this.assertSuccess(this.executeCommand("generate-key", "--with-key-password", passwordFile.getAbsolutePath(), "Pascal Password <pascal@password.protected>"));
        File certFile = this.pipeStdoutToFile("cert.asc");
        this.pipeFileToStdin(keyFile);
        this.assertSuccess(this.executeCommand("extract-cert"));
        String msg = "Hello, World!\n";
        this.pipeStringToStdin(msg);
        File encryptedFile = this.pipeStdoutToFile("msg.asc");
        this.assertSuccess(this.executeCommand("encrypt", "--sign-with", keyFile.getAbsolutePath(), "--with-key-password", passwordFile.getAbsolutePath(), "--no-armor", "--as", "binary", certFile.getAbsolutePath()));
        File verificationsFile = this.nonExistentFile("verifications");
        this.pipeFileToStdin(encryptedFile);
        ByteArrayOutputStream out = this.pipeStdoutToStream();
        this.assertSuccess(this.executeCommand("decrypt", "--verify-with", certFile.getAbsolutePath(), "--verifications-out", verificationsFile.getAbsolutePath(), "--with-key-password", passwordFile.getAbsolutePath(), keyFile.getAbsolutePath()));
        Assertions.assertEquals((Object)msg, (Object)out.toString());
    }

    @Test
    public void decryptGarbageFails() throws IOException {
        File keyFile = this.writeFile("key.asc", KEY);
        this.pipeStringToStdin("Some Garbage!");
        int exitCode = this.executeCommand("decrypt", keyFile.getAbsolutePath());
        Assertions.assertEquals((int)41, (int)exitCode);
    }

    @Test
    public void decryptMessageWithWrongKeyFails() throws IOException {
        File keyFile = this.pipeStdoutToFile("key.asc");
        this.assertSuccess(this.executeCommand("generate-key", "Bob <bob@pgpainless.org>"));
        String ciphertext = "-----BEGIN PGP MESSAGE-----\nVersion: PGPainless\n\nhF4D831k4umlLu4SAQdAYisjZTDRm217LHQbqjB766tm62CKTkRj3Gd0wYxVRCgw\n48SnOJINCJoPgDsxk2NiJmLCImoiET7IElqxN9htdDXQJwcRK+71r/ZyO4YJpWuX\n0sAAAcEFc3nT+un31sOi8KoBJlc5n+MemntQvcWDs8B87BEW/Ncjrs0s4pJpZKBQ\n/AWc4wLCI3ylfMQJB2pICqaOO3KP3WepgTIw5fuZm6YfriKQi7uZvVx1N+uaCIoa\nK2IVVf/7O9KZJ9GbsGYdpBj9IdaIZiVS3Xi8rwgQl3haI/EeHC3nnCsWyj23Fjt3\nLjbMqpHbSnp8U1cQ8rXavrREaKv69PFeJio6/hRg32TzJqn05dPALRxHMEkxxa4h\nFpVU\n=edS5\n-----END PGP MESSAGE-----";
        this.pipeStringToStdin(ciphertext);
        ByteArrayOutputStream out = this.pipeStdoutToStream();
        int exitCode = this.executeCommand("decrypt", keyFile.getAbsolutePath());
        Assertions.assertEquals((int)29, (int)exitCode);
        Assertions.assertEquals((int)0, (int)out.size());
    }

    @Test
    public void encryptWithPasswordADecryptWithPasswordBFails() throws IOException {
        File password1 = this.writeFile("password1", "swordfish");
        File password2 = this.writeFile("password2", "orange");
        this.pipeStringToStdin("Bonjour, le monde!\n");
        ByteArrayOutputStream ciphertextOut = this.pipeStdoutToStream();
        this.assertSuccess(this.executeCommand("encrypt", "--with-password", password1.getAbsolutePath()));
        this.pipeBytesToStdin(ciphertextOut.toByteArray());
        ByteArrayOutputStream out = this.pipeStdoutToStream();
        int exitCode = this.executeCommand("decrypt", "--with-password", password2.getAbsolutePath());
        Assertions.assertEquals((int)29, (int)exitCode);
        Assertions.assertEquals((int)0, (int)out.size());
    }

    @Test
    public void encryptWithGarbageCertFails() throws IOException {
        File garbageCert = this.writeFile("cert.asc", "This is garbage!");
        this.pipeStringToStdin("Hallo, Welt!\n");
        ByteArrayOutputStream out = this.pipeStdoutToStream();
        int exitCode = this.executeCommand("encrypt", garbageCert.getAbsolutePath());
        Assertions.assertEquals((int)41, (int)exitCode);
        Assertions.assertEquals((int)0, (int)out.size());
    }

    @Test
    public void encrypt_signWithGarbageKeyFails() throws IOException {
        File cert = this.writeFile("cert.asc", CERT);
        File garbageKey = this.writeFile("key.asc", "This is not a key!");
        this.pipeStringToStdin("Salut!\n");
        ByteArrayOutputStream out = this.pipeStdoutToStream();
        int exitCode = this.executeCommand("encrypt", "--sign-with", garbageKey.getAbsolutePath(), cert.getAbsolutePath());
        Assertions.assertEquals((int)41, (int)exitCode);
        Assertions.assertEquals((int)0, (int)out.size());
    }

    @Test
    public void decrypt_withGarbageKeyFails() throws IOException {
        File key = this.writeFile("key.asc", "this is garbage");
        String ciphertext = "-----BEGIN PGP MESSAGE-----\nVersion: PGPainless\n\nhF4D831k4umlLu4SAQdAYisjZTDRm217LHQbqjB766tm62CKTkRj3Gd0wYxVRCgw\n48SnOJINCJoPgDsxk2NiJmLCImoiET7IElqxN9htdDXQJwcRK+71r/ZyO4YJpWuX\n0sAAAcEFc3nT+un31sOi8KoBJlc5n+MemntQvcWDs8B87BEW/Ncjrs0s4pJpZKBQ\n/AWc4wLCI3ylfMQJB2pICqaOO3KP3WepgTIw5fuZm6YfriKQi7uZvVx1N+uaCIoa\nK2IVVf/7O9KZJ9GbsGYdpBj9IdaIZiVS3Xi8rwgQl3haI/EeHC3nnCsWyj23Fjt3\nLjbMqpHbSnp8U1cQ8rXavrREaKv69PFeJio6/hRg32TzJqn05dPALRxHMEkxxa4h\nFpVU\n=edS5\n-----END PGP MESSAGE-----";
        this.pipeStringToStdin(ciphertext);
        ByteArrayOutputStream out = this.pipeStdoutToStream();
        int exitCode = this.executeCommand("decrypt", key.getAbsolutePath());
        Assertions.assertEquals((int)41, (int)exitCode);
        Assertions.assertEquals((int)0, (int)out.size());
    }

    @Test
    public void decrypt_verifyWithGarbageCertFails() throws IOException {
        File key = this.writeFile("key.asc", KEY);
        File cert = this.writeFile("cert.asc", "now this is garbage");
        String ciphertext = "-----BEGIN PGP MESSAGE-----\nVersion: PGPainless\n\nhF4D831k4umlLu4SAQdAYisjZTDRm217LHQbqjB766tm62CKTkRj3Gd0wYxVRCgw\n48SnOJINCJoPgDsxk2NiJmLCImoiET7IElqxN9htdDXQJwcRK+71r/ZyO4YJpWuX\n0sAAAcEFc3nT+un31sOi8KoBJlc5n+MemntQvcWDs8B87BEW/Ncjrs0s4pJpZKBQ\n/AWc4wLCI3ylfMQJB2pICqaOO3KP3WepgTIw5fuZm6YfriKQi7uZvVx1N+uaCIoa\nK2IVVf/7O9KZJ9GbsGYdpBj9IdaIZiVS3Xi8rwgQl3haI/EeHC3nnCsWyj23Fjt3\nLjbMqpHbSnp8U1cQ8rXavrREaKv69PFeJio6/hRg32TzJqn05dPALRxHMEkxxa4h\nFpVU\n=edS5\n-----END PGP MESSAGE-----";
        File verificationsFile = this.nonExistentFile("verifications");
        this.pipeStringToStdin(ciphertext);
        ByteArrayOutputStream out = this.pipeStdoutToStream();
        int exitCode = this.executeCommand("decrypt", key.getAbsolutePath(), "--verify-with", cert.getAbsolutePath(), "--verifications-out", verificationsFile.getAbsolutePath());
        Assertions.assertEquals((int)41, (int)exitCode);
        Assertions.assertEquals((int)0, (int)out.size());
    }

    @Test
    public void encryptWithProtectedKey_wrongPassphraseFails() throws IOException {
        File password = this.writeFile("passphrase1", "orange");
        File wrongPassword = this.writeFile("passphrase2", "blue");
        File keyFile = this.pipeStdoutToFile("key.asc");
        this.assertSuccess(this.executeCommand("generate-key", "Pedro <pedro@pgpainless.org>", "--with-key-password", password.getAbsolutePath()));
        File certFile = this.pipeStdoutToFile("cert.asc");
        this.pipeFileToStdin(keyFile);
        this.assertSuccess(this.executeCommand("extract-cert"));
        String msg = "Guten Tag, Welt!\n";
        this.pipeStringToStdin(msg);
        ByteArrayOutputStream out = this.pipeStdoutToStream();
        int exitCode = this.executeCommand("encrypt", "--sign-with", keyFile.getAbsolutePath(), certFile.getAbsolutePath());
        Assertions.assertEquals((int)67, (int)exitCode);
        Assertions.assertEquals((int)0, (int)out.size());
        this.pipeStringToStdin("Guten Tag, Welt!\n");
        out = this.pipeStdoutToStream();
        exitCode = this.executeCommand("encrypt", "--sign-with", keyFile.getAbsolutePath(), "--with-key-password", wrongPassword.getAbsolutePath(), certFile.getAbsolutePath());
        Assertions.assertEquals((int)67, (int)exitCode);
        Assertions.assertEquals((int)0, (int)out.size());
        this.pipeStringToStdin("Guten Tag, Welt!\n");
        out = this.pipeStdoutToStream();
        this.assertSuccess(this.executeCommand("encrypt", "--sign-with", keyFile.getAbsolutePath(), "--with-key-password", password.getAbsolutePath(), certFile.getAbsolutePath()));
        String ciphertext = out.toString();
        this.pipeStringToStdin(ciphertext);
        out = this.pipeStdoutToStream();
        exitCode = this.executeCommand("decrypt", keyFile.getAbsolutePath());
        Assertions.assertEquals((int)67, (int)exitCode);
        Assertions.assertEquals((int)0, (int)out.size());
        this.pipeStringToStdin(ciphertext);
        out = this.pipeStdoutToStream();
        exitCode = this.executeCommand("decrypt", "--with-key-password", wrongPassword.getAbsolutePath(), keyFile.getAbsolutePath());
        Assertions.assertEquals((int)67, (int)exitCode);
        Assertions.assertEquals((int)0, (int)out.size());
        this.pipeStringToStdin(ciphertext);
        out = this.pipeStdoutToStream();
        this.assertSuccess(this.executeCommand("decrypt", "--with-key-password", password.getAbsolutePath(), keyFile.getAbsolutePath()));
        Assertions.assertEquals((Object)msg, (Object)out.toString());
    }
}

