/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.cli.commands;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.pgpainless.cli.commands.CLITest;
import org.slf4j.LoggerFactory;

public class RoundTripInlineSignInlineVerifyCmdTest
extends CLITest {
    private static final String KEY_1_PASSWORD = "takeDemHobbits2Isengard";
    private static final String KEY_1 = "-----BEGIN PGP PRIVATE KEY BLOCK-----\nVersion: PGPainless\nComment: 59F4 EC7D 4A87 3E69 7029  8FDE 9FF0 8738 DFC0 0224\nComment: Legolas <legolas@fellowship.ring>\n\nlIYEY2wKdxYJKwYBBAHaRw8BAQdALfUbOSOsPDg4IgX7Mrub3EtkX0rp02orL/0j\n2VpV1rf+CQMCVICwUO0SkvdgcPdvXO1cW4KIp6HCVVV6VgU5cvBlmrk9PNUQVBkb\n6S7oXQu0CgGwJ+QdbooBQqOjMy2MDy+UXaURTaVyWcmetsZJZzD2wrQhTGVnb2xh\ncyA8bGVnb2xhc0BmZWxsb3dzaGlwLnJpbmc+iI8EExYKAEEFAmNsCncJEJ/whzjf\nwAIkFiEEWfTsfUqHPmlwKY/en/CHON/AAiQCngECmwEFFgIDAQAECwkIBwUVCgkI\nCwKZAQAAE10BAN9tN4Le1p4giS6P/yFuKFlDBOeiq1S4EqwYG7qdcqemAP45O3w4\n3sXliOJBGDR/l/lOMHdPcTOb7VRwWbpIqx8LBJyLBGNsCncSCisGAQQBl1UBBQEB\nB0AMc+7s6uBqAQcDvfKkD5zYbmB9ZfwIjRWQq/XF+g8KQwMBCAf+CQMCVICwUO0S\nkvdgHLmKhKW1xxCNZAqQcIHa9F/cqb6Sq/oVFHj2bEYzmGVvFCVUpP7KJWGTeFT+\nBYK779quIqjxHOfzC3Jmo3BHkUPWYOa0rIh1BBgWCgAdBQJjbAp3Ap4BApsMBRYC\nAwEABAsJCAcFFQoJCAsACgkQn/CHON/AAiRUewD9HtKrCUf3S1yR28emzITWPgJS\nUA5mkzEMnYspV7zU4jgA/R6jj/5QqPszElCQNZGtvsDUwYo10iRlQkxPshcPNakJ\nnIYEY2wKdxYJKwYBBAHaRw8BAQdAYxpRGib/f/tu65gbsV22nmysVVmVgiQuDxyH\nrz7VCi/+CQMCVICwUO0SkvdgOYYbWltjQRDM3SW/Zw/DiZN9MYZYa0MTgs0SHoaM\n5LU7jMxNmPR1UtSqEO36QqW91q4fpEkGrdWE4gwjm1bth8pyYKiSFojVBBgWCgB9\nBQJjbAp3Ap4BApsCBRYCAwEABAsJCAcFFQoJCAtfIAQZFgoABgUCY2wKdwAKCRCW\nK491s9xIMHwKAQDpSWQqiFxFvls9eRGtJ1eQT+L3Z2rDel5zNV44IdTf/wEA0vnJ\nouSKKuiH6Ck2OEkXbElH6gdQvOCYA7Z9gVeeHQoACgkQn/CHON/AAiSD6QD+LTZx\nNU+t4wQlWOkSsjOLsH/Sk5DZq+4HyQnStlxUJpUBALZFkZps65IP03VkPnQWigfs\nYgztJA1z/rmm3fmFgMMG\n=daDH\n-----END PGP PRIVATE KEY BLOCK-----";
    private static final String CERT_1 = "-----BEGIN PGP PUBLIC KEY BLOCK-----\nVersion: PGPainless\nComment: 59F4 EC7D 4A87 3E69 7029  8FDE 9FF0 8738 DFC0 0224\nComment: Legolas <legolas@fellowship.ring>\n\nmDMEY2wKdxYJKwYBBAHaRw8BAQdALfUbOSOsPDg4IgX7Mrub3EtkX0rp02orL/0j\n2VpV1re0IUxlZ29sYXMgPGxlZ29sYXNAZmVsbG93c2hpcC5yaW5nPoiPBBMWCgBB\nBQJjbAp3CRCf8Ic438ACJBYhBFn07H1Khz5pcCmP3p/whzjfwAIkAp4BApsBBRYC\nAwEABAsJCAcFFQoJCAsCmQEAABNdAQDfbTeC3taeIIkuj/8hbihZQwTnoqtUuBKs\nGBu6nXKnpgD+OTt8ON7F5YjiQRg0f5f5TjB3T3Ezm+1UcFm6SKsfCwS4OARjbAp3\nEgorBgEEAZdVAQUBAQdADHPu7OrgagEHA73ypA+c2G5gfWX8CI0VkKv1xfoPCkMD\nAQgHiHUEGBYKAB0FAmNsCncCngECmwwFFgIDAQAECwkIBwUVCgkICwAKCRCf8Ic4\n38ACJFR7AP0e0qsJR/dLXJHbx6bMhNY+AlJQDmaTMQydiylXvNTiOAD9HqOP/lCo\n+zMSUJA1ka2+wNTBijXSJGVCTE+yFw81qQm4MwRjbAp3FgkrBgEEAdpHDwEBB0Bj\nGlEaJv9/+27rmBuxXbaebKxVWZWCJC4PHIevPtUKL4jVBBgWCgB9BQJjbAp3Ap4B\nApsCBRYCAwEABAsJCAcFFQoJCAtfIAQZFgoABgUCY2wKdwAKCRCWK491s9xIMHwK\nAQDpSWQqiFxFvls9eRGtJ1eQT+L3Z2rDel5zNV44IdTf/wEA0vnJouSKKuiH6Ck2\nOEkXbElH6gdQvOCYA7Z9gVeeHQoACgkQn/CHON/AAiSD6QD+LTZxNU+t4wQlWOkS\nsjOLsH/Sk5DZq+4HyQnStlxUJpUBALZFkZps65IP03VkPnQWigfsYgztJA1z/rmm\n3fmFgMMG\n=/lYl\n-----END PGP PUBLIC KEY BLOCK-----";
    private static final String CERT_1_SIGNING_KEY = "D8906FEB9842569834FEDA9E962B8F75B3DC4830 59F4EC7D4A873E6970298FDE9FF08738DFC00224";
    private static final String KEY_2 = "-----BEGIN PGP PRIVATE KEY BLOCK-----\nVersion: PGPainless\nComment: AEA0 FD2C 899D 3FC0 7781  5F00 2656 0D2A E53D B86F\nComment: Gollum <gollum@deep.cave>\n\nlFgEY2wKphYJKwYBBAHaRw8BAQdA9MXACulaJvjIuMKbsc+/fLJ523lODbHmuTpc\njpPdjaEAAP9Edg7yeIGEeNP0GrndUpNeZyFAXAlCHJObDbS80G6BBw9ktBlHb2xs\ndW0gPGdvbGx1bUBkZWVwLmNhdmU+iI8EExYKAEEFAmNsCqYJECZWDSrlPbhvFiEE\nrqD9LImdP8B3gV8AJlYNKuU9uG8CngECmwEFFgIDAQAECwkIBwUVCgkICwKZAQAA\nKSkBAOMq6ymNH83E5CBA/mn3DYLhnujzC9cVf/iX2zrsdXMvAQCWdfFy/PlGhP3K\nM+ej6WIRsx24Yy/NhNPcRJUzcv6dC5xdBGNsCqYSCisGAQQBl1UBBQEBB0DiN/5n\nAFQafWjnSkKhctFCNkfVRrnAea/2T/D8fYWeYwMBCAcAAP9HbxOhwxqz8I+pwk3e\nkZXNolWqagrYZkpNvqlBb/JJWBGViHUEGBYKAB0FAmNsCqYCngECmwwFFgIDAQAE\nCwkIBwUVCgkICwAKCRAmVg0q5T24bw2EAP4pUHVA2pkVspzEttIaQxdoHcnbwjae\nq12TmWqWDFFvwgD+O2EqHn0iXW49EOQrlP8g+bdWUlT0ZIW3C3Fv7nNA3AScWARj\nbAqmFgkrBgEEAdpHDwEBB0BHsmdF1Q0aU3YRVDeXGb904Nb7H/cxcasDhcbu2FTo\nHAAA/j1+WzozN/3lefo76eyENKkXl4f1rQlUreqytuaTsb0WEq6I1QQYFgoAfQUC\nY2wKpgKeAQKbAgUWAgMBAAQLCQgHBRUKCQgLXyAEGRYKAAYFAmNsCqYACgkQj73T\nbQGDFnN9OwD/QDDi1qq7DrGlENQf2mPDh36YgM7bREY1vHEbbUNoqy4A/RJzMuwt\nL1M49UzQS7OIGP12/9cT66XPGjpCL+6zLPwCAAoJECZWDSrlPbhvw3ABAOE7/Iit\nntMexrSK5jCd9JdCCNb2rjR6XA18rXFGOrVBAPwLKAogNFQlP2kUsObTnIaTCro2\ncjK8WE1pfIwQ0ArPCQ==\n=SzrG\n-----END PGP PRIVATE KEY BLOCK-----";
    private static final String CERT_2 = "-----BEGIN PGP PUBLIC KEY BLOCK-----\nVersion: PGPainless\nComment: AEA0 FD2C 899D 3FC0 7781  5F00 2656 0D2A E53D B86F\nComment: Gollum <gollum@deep.cave>\n\nmDMEY2wKphYJKwYBBAHaRw8BAQdA9MXACulaJvjIuMKbsc+/fLJ523lODbHmuTpc\njpPdjaG0GUdvbGx1bSA8Z29sbHVtQGRlZXAuY2F2ZT6IjwQTFgoAQQUCY2wKpgkQ\nJlYNKuU9uG8WIQSuoP0siZ0/wHeBXwAmVg0q5T24bwKeAQKbAQUWAgMBAAQLCQgH\nBRUKCQgLApkBAAApKQEA4yrrKY0fzcTkIED+afcNguGe6PML1xV/+JfbOux1cy8B\nAJZ18XL8+UaE/coz56PpYhGzHbhjL82E09xElTNy/p0LuDgEY2wKphIKKwYBBAGX\nVQEFAQEHQOI3/mcAVBp9aOdKQqFy0UI2R9VGucB5r/ZP8Px9hZ5jAwEIB4h1BBgW\nCgAdBQJjbAqmAp4BApsMBRYCAwEABAsJCAcFFQoJCAsACgkQJlYNKuU9uG8NhAD+\nKVB1QNqZFbKcxLbSGkMXaB3J28I2nqtdk5lqlgxRb8IA/jthKh59Il1uPRDkK5T/\nIPm3VlJU9GSFtwtxb+5zQNwEuDMEY2wKphYJKwYBBAHaRw8BAQdAR7JnRdUNGlN2\nEVQ3lxm/dODW+x/3MXGrA4XG7thU6ByI1QQYFgoAfQUCY2wKpgKeAQKbAgUWAgMB\nAAQLCQgHBRUKCQgLXyAEGRYKAAYFAmNsCqYACgkQj73TbQGDFnN9OwD/QDDi1qq7\nDrGlENQf2mPDh36YgM7bREY1vHEbbUNoqy4A/RJzMuwtL1M49UzQS7OIGP12/9cT\n66XPGjpCL+6zLPwCAAoJECZWDSrlPbhvw3ABAOE7/IitntMexrSK5jCd9JdCCNb2\nrjR6XA18rXFGOrVBAPwLKAogNFQlP2kUsObTnIaTCro2cjK8WE1pfIwQ0ArPCQ==\n=j1LR\n-----END PGP PUBLIC KEY BLOCK-----";
    private static final String CERT_2_SIGNING_KEY = "7A073EDF273C902796D259528FBDD36D01831673 AEA0FD2C899D3FC077815F0026560D2AE53DB86F";
    private static final String MESSAGE = "One does not simply use OpenPGP!\n\nThere is only one Lord of the Keys, only one who can bend them to his will. And he does not share power.";

    public RoundTripInlineSignInlineVerifyCmdTest() {
        super(LoggerFactory.getLogger(RoundTripInlineSignInlineVerifyCmdTest.class));
    }

    @Test
    public void createCleartextSignedMessage() throws IOException {
        File key = this.writeFile("key.asc", KEY_1);
        File password = this.writeFile("password", KEY_1_PASSWORD);
        this.pipeStringToStdin(MESSAGE);
        ByteArrayOutputStream ciphertextOut = this.pipeStdoutToStream();
        this.assertSuccess(this.executeCommand("inline-sign", "--as", "clearsigned", key.getAbsolutePath(), "--with-key-password", password.getAbsolutePath()));
        String cleartextSigned = ciphertextOut.toString();
        Assertions.assertTrue((boolean)cleartextSigned.startsWith("-----BEGIN PGP SIGNED MESSAGE-----\nHash: "));
        Assertions.assertTrue((boolean)cleartextSigned.contains(MESSAGE));
        Assertions.assertTrue((boolean)cleartextSigned.contains("\n-----BEGIN PGP SIGNATURE-----\n"));
        Assertions.assertTrue((boolean)cleartextSigned.endsWith("-----END PGP SIGNATURE-----\n"));
    }

    @Test
    public void createAndVerifyCleartextSignedMessage() throws IOException {
        File key = this.writeFile("key.asc", KEY_1);
        File password = this.writeFile("password", KEY_1_PASSWORD);
        this.pipeStringToStdin(MESSAGE);
        ByteArrayOutputStream ciphertextOut = this.pipeStdoutToStream();
        this.assertSuccess(this.executeCommand("inline-sign", "--as", "clearsigned", key.getAbsolutePath(), "--with-key-password", password.getAbsolutePath()));
        File cert = this.writeFile("cert.asc", CERT_1);
        File verifications = this.nonExistentFile("verifications");
        this.pipeStringToStdin(ciphertextOut.toString());
        ByteArrayOutputStream plaintextOut = this.pipeStdoutToStream();
        this.assertSuccess(this.executeCommand("inline-verify", "--verifications-out", verifications.getAbsolutePath(), cert.getAbsolutePath()));
        Assertions.assertEquals((Object)MESSAGE, (Object)plaintextOut.toString());
        String verificationString = this.readStringFromFile(verifications);
        Assertions.assertTrue((boolean)verificationString.contains(CERT_1_SIGNING_KEY));
    }

    @Test
    public void createAndVerifyMultiKeyBinarySignedMessage() throws IOException {
        File key1Pass = this.writeFile("password", KEY_1_PASSWORD);
        File key1 = this.writeFile("key1.asc", KEY_1);
        File key2 = this.writeFile("key2.asc", KEY_2);
        this.pipeStringToStdin(MESSAGE);
        ByteArrayOutputStream ciphertextOut = this.pipeStdoutToStream();
        this.assertSuccess(this.executeCommand("inline-sign", "--as", "binary", "--no-armor", key2.getAbsolutePath(), "--with-key-password", key1Pass.getAbsolutePath(), key1.getAbsolutePath()));
        Assertions.assertFalse((boolean)ciphertextOut.toString().startsWith("-----BEGIN PGP SIGNED MESSAGE-----\n"));
        byte[] unarmoredMessage = ciphertextOut.toByteArray();
        File cert1 = this.writeFile("cert1.asc", CERT_1);
        File cert2 = this.writeFile("cert2.asc", CERT_2);
        File verificationFile = this.nonExistentFile("verifications");
        this.pipeBytesToStdin(unarmoredMessage);
        ByteArrayOutputStream plaintextOut = this.pipeStdoutToStream();
        this.assertSuccess(this.executeCommand("inline-verify", "--verifications-out", verificationFile.getAbsolutePath(), cert1.getAbsolutePath(), cert2.getAbsolutePath()));
        Assertions.assertEquals((Object)MESSAGE, (Object)plaintextOut.toString());
        String verification = this.readStringFromFile(verificationFile);
        Assertions.assertTrue((boolean)verification.contains(CERT_1_SIGNING_KEY));
        Assertions.assertTrue((boolean)verification.contains(CERT_2_SIGNING_KEY));
    }

    @Test
    public void createTextSignedMessageInlineDetachAndDetachedVerify() throws IOException {
        File key = this.writeFile("key.asc", KEY_1);
        File password = this.writeFile("password", KEY_1_PASSWORD);
        this.pipeStringToStdin(MESSAGE);
        ByteArrayOutputStream ciphertextOut = this.pipeStdoutToStream();
        this.assertSuccess(this.executeCommand("inline-sign", "--as", "clearsigned", key.getAbsolutePath(), "--with-key-password", password.getAbsolutePath()));
        File sigFile = this.nonExistentFile("sig.asc");
        this.pipeStringToStdin(ciphertextOut.toString());
        ByteArrayOutputStream msgOut = this.pipeStdoutToStream();
        this.assertSuccess(this.executeCommand("inline-detach", "--signatures-out", sigFile.getAbsolutePath()));
        Assertions.assertEquals((Object)MESSAGE, (Object)msgOut.toString());
        File cert = this.writeFile("cert.asc", CERT_1);
        this.pipeStringToStdin(msgOut.toString());
        ByteArrayOutputStream verificationsOut = this.pipeStdoutToStream();
        this.assertSuccess(this.executeCommand("verify", sigFile.getAbsolutePath(), cert.getAbsolutePath()));
        String verificationString = verificationsOut.toString();
        Assertions.assertTrue((boolean)verificationString.contains(CERT_1_SIGNING_KEY));
    }
}

