/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.signature.builder;

import javax.annotation.Nullable;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.bouncycastle.openpgp.PGPSignature;
import org.bouncycastle.openpgp.PGPSignatureGenerator;
import org.pgpainless.algorithm.SignatureType;
import org.pgpainless.key.protection.SecretKeyRingProtector;
import org.pgpainless.signature.builder.AbstractSignatureBuilder;
import org.pgpainless.signature.subpackets.BaseSignatureSubpackets;
import org.pgpainless.signature.subpackets.SignatureSubpackets;

public class UniversalSignatureBuilder
extends AbstractSignatureBuilder<UniversalSignatureBuilder> {
    public UniversalSignatureBuilder(SignatureType signatureType, PGPSecretKey signingKey, SecretKeyRingProtector protector) throws PGPException {
        super(signatureType, signingKey, protector);
    }

    public UniversalSignatureBuilder(PGPSecretKey certificationKey, SecretKeyRingProtector protector, PGPSignature archetypeSignature) throws PGPException {
        super(certificationKey, protector, archetypeSignature);
    }

    @Override
    protected boolean isValidSignatureType(SignatureType type) {
        return true;
    }

    public SignatureSubpackets getHashedSubpackets() {
        return this.hashedSubpackets;
    }

    public SignatureSubpackets getUnhashedSubpackets() {
        return this.unhashedSubpackets;
    }

    public void applyCallback(@Nullable BaseSignatureSubpackets.Callback callback) {
        if (callback != null) {
            callback.modifyHashedSubpackets(this.getHashedSubpackets());
            callback.modifyUnhashedSubpackets(this.getUnhashedSubpackets());
        }
    }

    public PGPSignatureGenerator getSignatureGenerator() throws PGPException {
        return this.buildAndInitSignatureGenerator();
    }
}

