/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.cli;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Random;
import org.bouncycastle.openpgp.PGPUtil;
import org.bouncycastle.util.io.Streams;
import org.junit.jupiter.api.Assertions;

public class TestUtils {
    public static final String ALPHABET = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";
    private static final Random RANDOM = new Random();
    public static final String ARMOR_PRIVATE_KEY_HEADER = "-----BEGIN PGP PRIVATE KEY BLOCK-----";
    public static final byte[] ARMOR_PRIVATE_KEY_HEADER_BYTES = "-----BEGIN PGP PRIVATE KEY BLOCK-----".getBytes(StandardCharsets.UTF_8);
    public static final String ARMOR_SIGNATURE_HEADER = "-----BEGIN PGP SIGNATURE-----";
    public static final byte[] ARMOR_SIGNATURE_HEADER_BYTES = "-----BEGIN PGP SIGNATURE-----".getBytes(StandardCharsets.UTF_8);

    public static File createTempDirectory() throws IOException {
        String name = TestUtils.randomString(10);
        File dir = Files.createTempDirectory(name, new FileAttribute[0]).toFile();
        return dir;
    }

    public static File writeTempFile(File tempDir, byte[] value) throws IOException {
        File tempFile = new File(tempDir, TestUtils.randomString(10));
        tempFile.createNewFile();
        tempFile.deleteOnExit();
        FileOutputStream fileOutputStream = new FileOutputStream(tempFile);
        fileOutputStream.write(value);
        fileOutputStream.flush();
        fileOutputStream.close();
        return tempFile;
    }

    private static String randomString(int length) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            sb.append(ALPHABET.charAt(RANDOM.nextInt(ALPHABET.length())));
        }
        return sb.toString();
    }

    public static void assertSignatureEquals(String sig1, String sig2) throws IOException {
        TestUtils.assertSignatureEquals(sig1.getBytes(StandardCharsets.UTF_8), sig2.getBytes(StandardCharsets.UTF_8));
    }

    public static void assertSignatureEquals(byte[] sig1, byte[] sig2) throws IOException {
        InputStream sigIn1 = PGPUtil.getDecoderStream((InputStream)new ByteArrayInputStream(sig1));
        InputStream sigIn2 = PGPUtil.getDecoderStream((InputStream)new ByteArrayInputStream(sig2));
        TestUtils.assertSignatureEquals(sigIn1, sigIn2);
    }

    public static void assertSignatureEquals(InputStream sig1, InputStream sig2) throws IOException {
        ByteArrayOutputStream bout1 = new ByteArrayOutputStream();
        ByteArrayOutputStream bout2 = new ByteArrayOutputStream();
        Streams.pipeAll((InputStream)sig1, (OutputStream)bout1);
        Streams.pipeAll((InputStream)sig2, (OutputStream)bout2);
        Assertions.assertArrayEquals((byte[])bout1.toByteArray(), (byte[])bout2.toByteArray());
    }

    public static void assertSignatureIsArmored(byte[] sig) {
        Assertions.assertTrue((boolean)TestUtils.isSignatureArmored(sig), (String)("Signature encoding does not start with armor header.\nExpected: -----BEGIN PGP SIGNATURE-----\nActual: " + new String(sig)));
    }

    public static void assertSignatureIsNotArmored(byte[] sig) {
        Assertions.assertFalse((boolean)TestUtils.isSignatureArmored(sig), (String)("Signature encoding starts with armor header.\nActual: " + new String(sig)));
    }

    public static boolean isSignatureArmored(byte[] sig) {
        boolean same = true;
        for (int i = 0; i < ARMOR_SIGNATURE_HEADER_BYTES.length; ++i) {
            if (sig[i] == ARMOR_SIGNATURE_HEADER_BYTES[i]) continue;
            same = false;
            break;
        }
        return same;
    }
}

