/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.cli.commands;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.pgpainless.cli.TestUtils;
import org.pgpainless.cli.commands.CLITest;
import org.slf4j.LoggerFactory;

public class InlineDetachCmdTest
extends CLITest {
    private static final String CERT = "-----BEGIN PGP PUBLIC KEY BLOCK-----\nVersion: BCPG v1.64\n\nmFIEXhtfCBMIKoZIzj0DAQcCAwTGSFMBUOSLusXS8hdNHbdK3gN8hS7jd4ky7Czl\nmSti+oVyRJUwQAFZJ1NMsg1H8flSJP1/9YbHd9FBU4bHKGKPtBE8ZW1pbEBlbWFp\nbC51c2VyPoh1BBMTCgAdBQJeG18IAhsjBRYCAwEABAsJCAcFFQoJCAsCHgEACgkQ\nVzbmkxrPNwz8rAD/S/VCQc5NJLArgTDkgrt3Q573HiYfrIQo1uk3dwV15WIBAMiq\noDmRMb8jzOBv6FGW4P5WAubPdnAvDD7XmArD+TSeuFYEXhtfCBIIKoZIzj0DAQcC\nAwTgWDWmHJLQUQ35Qg/rINmUhkUhj1E4O5t6Y2PipbqlGfDufLmIKnX40BoJPS4G\nHW7U0QXfwSaTXa1BAaNsMUomAwEIB4h1BBgTCgAdBQJeG18IAhsMBRYCAwEABAsJ\nCAcFFQoJCAsCHgEACgkQVzbmkxrPNwxOcwEA19Fnhw7XwpQoT61Fqg54vroAwTZ3\nT5A+LOdevAtzNOUA/RWeKfOGk6D+vKYRNpMJyqsHi/vBeKwXoeN0n6HuExVF\n=a1W7\n-----END PGP PUBLIC KEY BLOCK-----";
    private static final String CLEAR_SIGNED_MESSAGE = "-----BEGIN PGP SIGNED MESSAGE-----\nHash: SHA512\n\nAh, Juliet, if the measure of thy joy\nBe heaped like mine, and that thy skill be more\nTo blazon it, then sweeten with thy breath\nThis neighbor air, and let rich music\u2019s tongue\nUnfold the imagined happiness that both\nReceive in either by this dear encounter.\n-----BEGIN PGP SIGNATURE-----\n\niHUEARMKAB0WIQRPZlxNwsRmC8ZCXkFXNuaTGs83DAUCYJ/x5gAKCRBXNuaTGs83\nDFRwAP9/4wMvV3WcX59Clo7mkRce6iwW3VBdiN+yMu3tjmHB2wD/RfE28Q1v4+eo\nySNgbyvqYYsNr0fnBwaG3aaj+u5ExiE=\n=Z2SO\n-----END PGP SIGNATURE-----";
    private static final String CLEAR_SIGNED_SIGNATURE = "-----BEGIN PGP SIGNATURE-----\n\niHUEARMKAB0WIQRPZlxNwsRmC8ZCXkFXNuaTGs83DAUCYJ/x5gAKCRBXNuaTGs83\nDFRwAP9/4wMvV3WcX59Clo7mkRce6iwW3VBdiN+yMu3tjmHB2wD/RfE28Q1v4+eo\nySNgbyvqYYsNr0fnBwaG3aaj+u5ExiE=\n=Z2SO\n-----END PGP SIGNATURE-----";
    private static final String CLEAR_SIGNED_BODY = "Ah, Juliet, if the measure of thy joy\nBe heaped like mine, and that thy skill be more\nTo blazon it, then sweeten with thy breath\nThis neighbor air, and let rich music\u2019s tongue\nUnfold the imagined happiness that both\nReceive in either by this dear encounter.";

    public InlineDetachCmdTest() {
        super(LoggerFactory.getLogger(InlineDetachCmdTest.class));
    }

    @Test
    public void detachInbandSignatureAndMessage() throws IOException {
        this.pipeStringToStdin(CLEAR_SIGNED_MESSAGE);
        ByteArrayOutputStream msgOut = this.pipeStdoutToStream();
        File sigFile = this.nonExistentFile("sig.out");
        this.assertSuccess(this.executeCommand("inline-detach", "--signatures-out", sigFile.getAbsolutePath()));
        Assertions.assertTrue((boolean)sigFile.exists(), (String)"Signature file must have been written.");
        Assertions.assertEquals((Object)CLEAR_SIGNED_BODY, (Object)msgOut.toString());
        String sig = this.readStringFromFile(sigFile);
        TestUtils.assertSignatureIsArmored(sig.getBytes());
        TestUtils.assertSignatureEquals(CLEAR_SIGNED_SIGNATURE, sig);
        File certFile = this.writeFile("cert.asc", CERT);
        this.pipeStringToStdin(msgOut.toString());
        ByteArrayOutputStream verifyOut = this.pipeStdoutToStream();
        this.assertSuccess(this.executeCommand("verify", sigFile.getAbsolutePath(), certFile.getAbsolutePath()));
        Assertions.assertEquals((Object)"2021-05-15T16:08:06Z 4F665C4DC2C4660BC6425E415736E6931ACF370C 4F665C4DC2C4660BC6425E415736E6931ACF370C\n", (Object)verifyOut.toString());
    }

    @Test
    public void detachInbandSignatureAndMessageNoArmor() throws IOException {
        this.pipeStringToStdin(CLEAR_SIGNED_MESSAGE);
        ByteArrayOutputStream msgOut = this.pipeStdoutToStream();
        File sigFile = this.nonExistentFile("sig.out");
        this.assertSuccess(this.executeCommand("inline-detach", "--signatures-out", sigFile.getAbsolutePath(), "--no-armor"));
        Assertions.assertEquals((Object)CLEAR_SIGNED_BODY, (Object)msgOut.toString());
        Assertions.assertTrue((boolean)sigFile.exists(), (String)"Signature file must have been written.");
        byte[] sig = this.readBytesFromFile(sigFile);
        TestUtils.assertSignatureIsNotArmored(sig);
        TestUtils.assertSignatureEquals(CLEAR_SIGNED_SIGNATURE.getBytes(StandardCharsets.UTF_8), sig);
        this.pipeBytesToStdin(msgOut.toByteArray());
        ByteArrayOutputStream verifyOut = this.pipeStdoutToStream();
        File certFile = this.writeFile("cert.asc", CERT);
        this.assertSuccess(this.executeCommand("verify", sigFile.getAbsolutePath(), certFile.getAbsolutePath()));
        Assertions.assertEquals((Object)"2021-05-15T16:08:06Z 4F665C4DC2C4660BC6425E415736E6931ACF370C 4F665C4DC2C4660BC6425E415736E6931ACF370C\n", (Object)verifyOut.toString());
    }

    @Test
    public void existingSignatureOutCausesException() throws IOException {
        this.pipeStringToStdin(CLEAR_SIGNED_MESSAGE);
        ByteArrayOutputStream msgOut = this.pipeStdoutToStream();
        File existingSigFile = this.writeFile("sig.asc", CLEAR_SIGNED_SIGNATURE);
        int exit = this.executeCommand("inline-detach", "--signatures-out", existingSigFile.getAbsolutePath());
        Assertions.assertEquals((int)59, (int)exit);
        Assertions.assertEquals((int)0, (int)msgOut.size());
    }
}

