/*
 * Decompiled with CFR 0.152.
 */
package sop.cli.picocli.commands;

import java.io.IOException;
import picocli.CommandLine;
import sop.Ready;
import sop.cli.picocli.SopCLI;
import sop.cli.picocli.commands.AbstractSopCmd;
import sop.enums.ArmorLabel;
import sop.exception.SOPGPException;
import sop.operation.Armor;

@CommandLine.Command(name="armor", resourceBundle="sop", exitCodeOnInvalidInput=37)
public class ArmorCmd
extends AbstractSopCmd {
    @CommandLine.Option(names={"--label"}, descriptionKey="sop.armor.usage.option.label", paramLabel="{auto|sig|key|cert|message}")
    ArmorLabel label;

    @Override
    public void run() {
        Armor armor = this.throwIfUnsupportedSubcommand(SopCLI.getSop().armor(), "armor");
        if (this.label != null) {
            try {
                armor.label(this.label);
            }
            catch (SOPGPException.UnsupportedOption unsupportedOption) {
                String errorMsg = this.getMsg("sop.error.feature_support.option_not_supported", "--label");
                throw new SOPGPException.UnsupportedOption(errorMsg, unsupportedOption);
            }
        }
        try {
            Ready ready = armor.data(System.in);
            ready.writeTo(System.out);
        }
        catch (SOPGPException.BadData badData) {
            String errorMsg = this.getMsg("sop.error.input.stdin_not_openpgp_data");
            throw new SOPGPException.BadData(errorMsg, badData);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

