/*
 * Decompiled with CFR 0.152.
 */
package sop.cli.picocli.commands;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.regex.Pattern;
import picocli.CommandLine;
import sop.DecryptionResult;
import sop.ReadyWithResult;
import sop.SessionKey;
import sop.Verification;
import sop.cli.picocli.SopCLI;
import sop.cli.picocli.commands.AbstractSopCmd;
import sop.exception.SOPGPException;
import sop.operation.Decrypt;
import sop.util.HexUtil;

@CommandLine.Command(name="decrypt", resourceBundle="sop", exitCodeOnInvalidInput=37)
public class DecryptCmd
extends AbstractSopCmd {
    private static final String OPT_WITH_SESSION_KEY = "--with-session-key";
    private static final String OPT_WITH_PASSWORD = "--with-password";
    private static final String OPT_NOT_BEFORE = "--not-before";
    private static final String OPT_NOT_AFTER = "--not-after";
    private static final String OPT_SESSION_KEY_OUT = "--session-key-out";
    private static final String OPT_VERIFY_OUT = "--verify-out";
    private static final String OPT_VERIFY_WITH = "--verify-with";
    private static final String OPT_WITH_KEY_PASSWORD = "--with-key-password";
    @CommandLine.Option(names={"--session-key-out"}, descriptionKey="sop.decrypt.usage.option.session_key_out", paramLabel="SESSIONKEY")
    String sessionKeyOut;
    @CommandLine.Option(names={"--with-session-key"}, descriptionKey="sop.decrypt.usage.option.with_session_key", paramLabel="SESSIONKEY")
    List<String> withSessionKey = new ArrayList<String>();
    @CommandLine.Option(names={"--with-password"}, descriptionKey="sop.decrypt.usage.option.with_password", paramLabel="PASSWORD")
    List<String> withPassword = new ArrayList<String>();
    @CommandLine.Option(names={"--verify-out"}, descriptionKey="sop.decrypt.usage.option.verify_out", paramLabel="VERIFICATIONS")
    String verifyOut;
    @CommandLine.Option(names={"--verify-with"}, descriptionKey="sop.decrypt.usage.option.certs", paramLabel="CERT")
    List<String> certs = new ArrayList<String>();
    @CommandLine.Option(names={"--not-before"}, descriptionKey="sop.decrypt.usage.option.not_before", paramLabel="DATE")
    String notBefore = "-";
    @CommandLine.Option(names={"--not-after"}, descriptionKey="sop.decrypt.usage.option.not_after", paramLabel="DATE")
    String notAfter = "now";
    @CommandLine.Parameters(index="0..*", descriptionKey="sop.decrypt.usage.param.keys", paramLabel="KEY")
    List<String> keys = new ArrayList<String>();
    @CommandLine.Option(names={"--with-key-password"}, descriptionKey="sop.decrypt.usage.option.with_key_password", paramLabel="PASSWORD")
    List<String> withKeyPassword = new ArrayList<String>();

    @Override
    public void run() {
        Decrypt decrypt = this.throwIfUnsupportedSubcommand(SopCLI.getSop().decrypt(), "decrypt");
        this.throwIfOutputExists(this.verifyOut);
        this.throwIfOutputExists(this.sessionKeyOut);
        this.setNotAfter(this.notAfter, decrypt);
        this.setNotBefore(this.notBefore, decrypt);
        this.setWithPasswords(this.withPassword, decrypt);
        this.setWithSessionKeys(this.withSessionKey, decrypt);
        this.setWithKeyPassword(this.withKeyPassword, decrypt);
        this.setVerifyWith(this.certs, decrypt);
        this.setDecryptWith(this.keys, decrypt);
        if (this.verifyOut != null && this.certs.isEmpty()) {
            String errorMsg = this.getMsg("sop.error.usage.option_requires_other_option", OPT_VERIFY_OUT, OPT_VERIFY_WITH);
            throw new SOPGPException.IncompleteVerification(errorMsg);
        }
        try {
            ReadyWithResult<DecryptionResult> ready = decrypt.ciphertext(System.in);
            DecryptionResult result = ready.writeTo(System.out);
            this.writeSessionKeyOut(result);
            this.writeVerifyOut(result);
        }
        catch (SOPGPException.BadData badData) {
            String errorMsg = this.getMsg("sop.error.input.stdin_not_a_message");
            throw new SOPGPException.BadData(errorMsg, badData);
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
    }

    private void writeVerifyOut(DecryptionResult result) throws IOException {
        if (this.verifyOut != null) {
            try (OutputStream fileOut = this.getOutput(this.verifyOut);){
                PrintWriter writer = new PrintWriter(fileOut);
                for (Verification verification : result.getVerifications()) {
                    writer.println(verification.toString());
                }
                writer.flush();
            }
        }
    }

    private void writeSessionKeyOut(DecryptionResult result) throws IOException {
        if (this.sessionKeyOut != null) {
            try (OutputStream outputStream = this.getOutput(this.sessionKeyOut);){
                if (!result.getSessionKey().isPresent()) {
                    String errorMsg = this.getMsg("sop.error.runtime.no_session_key_extracted");
                    throw new SOPGPException.UnsupportedOption(String.format(errorMsg, OPT_SESSION_KEY_OUT));
                }
                SessionKey sessionKey = result.getSessionKey().get();
                outputStream.write(sessionKey.getAlgorithm());
                outputStream.write(sessionKey.getKey());
            }
        }
    }

    private void setDecryptWith(List<String> keys, Decrypt decrypt) {
        for (String key : keys) {
            try {
                InputStream keyIn = this.getInput(key);
                try {
                    decrypt.withKey(keyIn);
                }
                finally {
                    if (keyIn == null) continue;
                    keyIn.close();
                }
            }
            catch (SOPGPException.KeyIsProtected keyIsProtected) {
                String errorMsg = this.getMsg("sop.error.runtime.cannot_unlock_key", key);
                throw new SOPGPException.KeyIsProtected(errorMsg, keyIsProtected);
            }
            catch (SOPGPException.BadData badData) {
                String errorMsg = this.getMsg("sop.error.input.not_a_private_key", key);
                throw new SOPGPException.BadData(errorMsg, badData);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private void setVerifyWith(List<String> certs, Decrypt decrypt) {
        for (String cert : certs) {
            try {
                InputStream certIn = this.getInput(cert);
                try {
                    decrypt.verifyWithCert(certIn);
                }
                finally {
                    if (certIn == null) continue;
                    certIn.close();
                }
            }
            catch (SOPGPException.BadData badData) {
                String errorMsg = this.getMsg("sop.error.input.not_a_certificate", cert);
                throw new SOPGPException.BadData(errorMsg, badData);
            }
            catch (IOException ioException) {
                throw new RuntimeException(ioException);
            }
        }
    }

    private void setWithSessionKeys(List<String> withSessionKey, Decrypt decrypt) {
        Pattern sessionKeyPattern = Pattern.compile("^\\d+:[0-9A-F]+$");
        for (String sessionKeyFile : withSessionKey) {
            String sessionKey;
            try {
                sessionKey = DecryptCmd.stringFromInputStream(this.getInput(sessionKeyFile));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            if (!sessionKeyPattern.matcher(sessionKey).matches()) {
                String errorMsg = this.getMsg("sop.error.input.malformed_session_key");
                throw new IllegalArgumentException(errorMsg);
            }
            String[] split = sessionKey.split(":");
            byte algorithm = (byte)Integer.parseInt(split[0]);
            byte[] key = HexUtil.hexToBytes(split[1]);
            try {
                decrypt.withSessionKey(new SessionKey(algorithm, key));
            }
            catch (SOPGPException.UnsupportedOption unsupportedOption) {
                String errorMsg = this.getMsg("sop.error.feature_support.option_not_supported", OPT_WITH_SESSION_KEY);
                throw new SOPGPException.UnsupportedOption(errorMsg, unsupportedOption);
            }
        }
    }

    private void setWithPasswords(List<String> withPassword, Decrypt decrypt) {
        for (String passwordFile : withPassword) {
            try {
                String password = DecryptCmd.stringFromInputStream(this.getInput(passwordFile));
                decrypt.withPassword(password);
            }
            catch (SOPGPException.UnsupportedOption unsupportedOption) {
                String errorMsg = this.getMsg("sop.error.feature_support.option_not_supported", OPT_WITH_PASSWORD);
                throw new SOPGPException.UnsupportedOption(errorMsg, unsupportedOption);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private void setWithKeyPassword(List<String> withKeyPassword, Decrypt decrypt) {
        for (String passwordFile : withKeyPassword) {
            try {
                String password = DecryptCmd.stringFromInputStream(this.getInput(passwordFile));
                decrypt.withKeyPassword(password);
            }
            catch (SOPGPException.UnsupportedOption unsupportedOption) {
                String errorMsg = this.getMsg("sop.error.feature_support.option_not_supported", OPT_WITH_KEY_PASSWORD);
                throw new SOPGPException.UnsupportedOption(errorMsg, unsupportedOption);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private void setNotAfter(String notAfter, Decrypt decrypt) {
        Date notAfterDate = this.parseNotAfter(notAfter);
        try {
            decrypt.verifyNotAfter(notAfterDate);
        }
        catch (SOPGPException.UnsupportedOption unsupportedOption) {
            String errorMsg = this.getMsg("sop.error.feature_support.option_not_supported", OPT_NOT_AFTER);
            throw new SOPGPException.UnsupportedOption(errorMsg, unsupportedOption);
        }
    }

    private void setNotBefore(String notBefore, Decrypt decrypt) {
        Date notBeforeDate = this.parseNotBefore(notBefore);
        try {
            decrypt.verifyNotBefore(notBeforeDate);
        }
        catch (SOPGPException.UnsupportedOption unsupportedOption) {
            String errorMsg = this.getMsg("sop.error.feature_support.option_not_supported", OPT_NOT_BEFORE);
            throw new SOPGPException.UnsupportedOption(errorMsg, unsupportedOption);
        }
    }
}

