/*
 * Decompiled with CFR 0.152.
 */
package sop.cli.picocli.commands;

import java.io.IOException;
import picocli.CommandLine;
import sop.Ready;
import sop.cli.picocli.SopCLI;
import sop.cli.picocli.commands.AbstractSopCmd;
import sop.exception.SOPGPException;
import sop.operation.ExtractCert;

@CommandLine.Command(name="extract-cert", resourceBundle="sop", exitCodeOnInvalidInput=37)
public class ExtractCertCmd
extends AbstractSopCmd {
    @CommandLine.Option(names={"--no-armor"}, descriptionKey="sop.extract-cert.usage.option.armor", negatable=true)
    boolean armor = true;

    @Override
    public void run() {
        ExtractCert extractCert = this.throwIfUnsupportedSubcommand(SopCLI.getSop().extractCert(), "extract-cert");
        if (!this.armor) {
            extractCert.noArmor();
        }
        try {
            Ready ready = extractCert.key(System.in);
            ready.writeTo(System.out);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (SOPGPException.BadData badData) {
            String errorMsg = this.getMsg("sop.error.input.stdin_not_a_private_key");
            throw new SOPGPException.BadData(errorMsg, badData);
        }
    }
}

