/*
 * Decompiled with CFR 0.152.
 */
package sop.cli.picocli.commands;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import picocli.CommandLine;
import sop.Ready;
import sop.cli.picocli.SopCLI;
import sop.cli.picocli.commands.AbstractSopCmd;
import sop.exception.SOPGPException;
import sop.operation.GenerateKey;

@CommandLine.Command(name="generate-key", resourceBundle="sop", exitCodeOnInvalidInput=37)
public class GenerateKeyCmd
extends AbstractSopCmd {
    @CommandLine.Option(names={"--no-armor"}, descriptionKey="sop.generate-key.usage.option.armor", negatable=true)
    boolean armor = true;
    @CommandLine.Parameters(descriptionKey="sop.generate-key.usage.option.user_id")
    List<String> userId = new ArrayList<String>();
    @CommandLine.Option(names={"--with-key-password"}, descriptionKey="sop.generate-key.usage.option.with_key_password", paramLabel="PASSWORD")
    String withKeyPassword;

    @Override
    public void run() {
        GenerateKey generateKey = this.throwIfUnsupportedSubcommand(SopCLI.getSop().generateKey(), "generate-key");
        for (String userId : this.userId) {
            generateKey.userId(userId);
        }
        if (!this.armor) {
            generateKey.noArmor();
        }
        if (this.withKeyPassword != null) {
            try {
                String password = GenerateKeyCmd.stringFromInputStream(this.getInput(this.withKeyPassword));
                generateKey.withKeyPassword(password);
            }
            catch (SOPGPException.UnsupportedOption e) {
                String errorMsg = this.getMsg("sop.error.feature_support.option_not_supported", "--with-key-password");
                throw new SOPGPException.UnsupportedOption(errorMsg, e);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        try {
            Ready ready = generateKey.generate();
            ready.writeTo(System.out);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

