/*
 * Decompiled with CFR 0.152.
 */
package sop.cli.picocli.commands;

import java.io.IOException;
import java.io.OutputStream;
import picocli.CommandLine;
import sop.Signatures;
import sop.cli.picocli.SopCLI;
import sop.cli.picocli.commands.AbstractSopCmd;
import sop.operation.InlineDetach;

@CommandLine.Command(name="inline-detach", resourceBundle="sop", exitCodeOnInvalidInput=37)
public class InlineDetachCmd
extends AbstractSopCmd {
    @CommandLine.Option(names={"--signatures-out"}, descriptionKey="sop.inline-detach.usage.option.signatures_out", paramLabel="SIGNATURES")
    String signaturesOut;
    @CommandLine.Option(names={"--no-armor"}, descriptionKey="sop.inline-detach.usage.option.armor", negatable=true)
    boolean armor = true;

    @Override
    public void run() {
        InlineDetach inlineDetach = this.throwIfUnsupportedSubcommand(SopCLI.getSop().inlineDetach(), "inline-detach");
        this.throwIfOutputExists(this.signaturesOut);
        this.throwIfMissingArg(this.signaturesOut, "--signatures-out");
        if (!this.armor) {
            inlineDetach.noArmor();
        }
        try (OutputStream outputStream = this.getOutput(this.signaturesOut);){
            Signatures signatures = inlineDetach.message(System.in).writeTo(System.out);
            signatures.writeTo(outputStream);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

