/*
 * Decompiled with CFR 0.152.
 */
package sop.cli.picocli.commands;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import picocli.CommandLine;
import sop.Ready;
import sop.cli.picocli.SopCLI;
import sop.cli.picocli.commands.AbstractSopCmd;
import sop.enums.InlineSignAs;
import sop.exception.SOPGPException;
import sop.operation.InlineSign;

@CommandLine.Command(name="inline-sign", resourceBundle="sop", exitCodeOnInvalidInput=37)
public class InlineSignCmd
extends AbstractSopCmd {
    @CommandLine.Option(names={"--no-armor"}, descriptionKey="sop.inline-sign.usage.option.armor", negatable=true)
    boolean armor = true;
    @CommandLine.Option(names={"--as"}, descriptionKey="sop.inline-sign.usage.option.as", paramLabel="{binary|text|cleartextsigned}")
    InlineSignAs type;
    @CommandLine.Parameters(descriptionKey="sop.inline-sign.usage.parameter.keys", paramLabel="KEYS")
    List<String> secretKeyFile = new ArrayList<String>();
    @CommandLine.Option(names={"--with-key-password"}, descriptionKey="sop.inline-sign.usage.option.with_key_password", paramLabel="PASSWORD")
    List<String> withKeyPassword = new ArrayList<String>();

    @Override
    public void run() {
        InlineSign inlineSign = this.throwIfUnsupportedSubcommand(SopCLI.getSop().inlineSign(), "inline-sign");
        if (this.type != null) {
            try {
                inlineSign.mode(this.type);
            }
            catch (SOPGPException.UnsupportedOption unsupportedOption) {
                String errorMsg = this.getMsg("sop.error.feature_support.option_not_supported", "--as");
                throw new SOPGPException.UnsupportedOption(errorMsg, unsupportedOption);
            }
        }
        if (this.secretKeyFile.isEmpty()) {
            String errorMsg = this.getMsg("sop.error.usage.parameter_required", "KEYS");
            throw new SOPGPException.MissingArg(errorMsg);
        }
        for (String passwordFile : this.withKeyPassword) {
            try {
                String password = InlineSignCmd.stringFromInputStream(this.getInput(passwordFile));
                inlineSign.withKeyPassword(password);
            }
            catch (SOPGPException.UnsupportedOption unsupportedOption) {
                String errorMsg = this.getMsg("sop.error.feature_support.option_not_supported", "--with-key-password");
                throw new SOPGPException.UnsupportedOption(errorMsg, unsupportedOption);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        for (String keyInput : this.secretKeyFile) {
            try {
                InputStream keyIn = this.getInput(keyInput);
                try {
                    inlineSign.key(keyIn);
                }
                finally {
                    if (keyIn == null) continue;
                    keyIn.close();
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            catch (SOPGPException.KeyIsProtected e) {
                String errorMsg = this.getMsg("sop.error.runtime.cannot_unlock_key", keyInput);
                throw new SOPGPException.KeyIsProtected(errorMsg, e);
            }
            catch (SOPGPException.BadData badData) {
                String errorMsg = this.getMsg("sop.error.input.not_a_private_key", keyInput);
                throw new SOPGPException.BadData(errorMsg, badData);
            }
        }
        if (!this.armor) {
            inlineSign.noArmor();
        }
        try {
            Ready ready = inlineSign.data(System.in);
            ready.writeTo(System.out);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

