/*
 * Decompiled with CFR 0.152.
 */
package sop.cli.picocli.commands;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import picocli.CommandLine;
import sop.MicAlg;
import sop.ReadyWithResult;
import sop.SigningResult;
import sop.cli.picocli.SopCLI;
import sop.cli.picocli.commands.AbstractSopCmd;
import sop.enums.SignAs;
import sop.exception.SOPGPException;
import sop.operation.DetachedSign;

@CommandLine.Command(name="sign", resourceBundle="sop", exitCodeOnInvalidInput=37)
public class SignCmd
extends AbstractSopCmd {
    @CommandLine.Option(names={"--no-armor"}, descriptionKey="sop.sign.usage.option.armor", negatable=true)
    boolean armor = true;
    @CommandLine.Option(names={"--as"}, descriptionKey="sop.sign.usage.option.as", paramLabel="{binary|text}")
    SignAs type;
    @CommandLine.Parameters(descriptionKey="sop.sign.usage.parameter.keys", paramLabel="KEYS")
    List<String> secretKeyFile = new ArrayList<String>();
    @CommandLine.Option(names={"--with-key-password"}, descriptionKey="sop.sign.usage.option.with_key_password", paramLabel="PASSWORD")
    List<String> withKeyPassword = new ArrayList<String>();
    @CommandLine.Option(names={"--micalg-out"}, descriptionKey="sop.sign.usage.option.micalg_out", paramLabel="MICALG")
    String micAlgOut;

    @Override
    public void run() {
        DetachedSign detachedSign = this.throwIfUnsupportedSubcommand(SopCLI.getSop().detachedSign(), "sign");
        this.throwIfOutputExists(this.micAlgOut);
        this.throwIfEmptyParameters(this.secretKeyFile, "KEYS");
        if (this.type != null) {
            try {
                detachedSign.mode(this.type);
            }
            catch (SOPGPException.UnsupportedOption unsupportedOption) {
                String errorMsg = this.getMsg("sop.error.feature_support.option_not_supported", "--as");
                throw new SOPGPException.UnsupportedOption(errorMsg, unsupportedOption);
            }
        }
        for (String passwordFile : this.withKeyPassword) {
            try {
                String password = SignCmd.stringFromInputStream(this.getInput(passwordFile));
                detachedSign.withKeyPassword(password);
            }
            catch (SOPGPException.UnsupportedOption unsupportedOption) {
                String errorMsg = this.getMsg("sop.error.feature_support.option_not_supported", "--with-key-password");
                throw new SOPGPException.UnsupportedOption(errorMsg, unsupportedOption);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        for (String keyInput : this.secretKeyFile) {
            try {
                InputStream keyIn = this.getInput(keyInput);
                try {
                    detachedSign.key(keyIn);
                }
                finally {
                    if (keyIn == null) continue;
                    keyIn.close();
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            catch (SOPGPException.KeyIsProtected keyIsProtected) {
                String errorMsg = this.getMsg("sop.error.runtime.cannot_unlock_key", keyInput);
                throw new SOPGPException.KeyIsProtected(errorMsg, keyIsProtected);
            }
            catch (SOPGPException.BadData badData) {
                String errorMsg = this.getMsg("sop.error.input.not_a_private_key", keyInput);
                throw new SOPGPException.BadData(errorMsg, badData);
            }
        }
        if (!this.armor) {
            detachedSign.noArmor();
        }
        try {
            ReadyWithResult<SigningResult> ready = detachedSign.data(System.in);
            SigningResult result = ready.writeTo(System.out);
            MicAlg micAlg = result.getMicAlg();
            if (this.micAlgOut != null) {
                OutputStream outputStream = this.getOutput(this.micAlgOut);
                micAlg.writeTo(outputStream);
                outputStream.close();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

