/*
 * Decompiled with CFR 0.152.
 */
package sop.cli.picocli.commands;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import picocli.CommandLine;
import sop.ReadyWithResult;
import sop.Verification;
import sop.cli.picocli.SopCLI;
import sop.cli.picocli.commands.AbstractSopCmd;
import sop.exception.SOPGPException;
import sop.operation.InlineVerify;

@CommandLine.Command(name="inline-verify", resourceBundle="msg_inline-verify", exitCodeOnInvalidInput=37)
public class InlineVerifyCmd
extends AbstractSopCmd {
    @CommandLine.Parameters(arity="1..*", paramLabel="CERT")
    List<String> certificates = new ArrayList<String>();
    @CommandLine.Option(names={"--not-before"}, paramLabel="DATE")
    String notBefore = "-";
    @CommandLine.Option(names={"--not-after"}, paramLabel="DATE")
    String notAfter = "now";
    @CommandLine.Option(names={"--verifications-out"})
    String verificationsOut;

    @Override
    public void run() {
        String errorMsg;
        InlineVerify inlineVerify = this.throwIfUnsupportedSubcommand(SopCLI.getSop().inlineVerify(), "inline-verify");
        this.throwIfOutputExists(this.verificationsOut);
        if (this.notAfter != null) {
            try {
                inlineVerify.notAfter(this.parseNotAfter(this.notAfter));
            }
            catch (SOPGPException.UnsupportedOption unsupportedOption) {
                String errorMsg2 = this.getMsg("sop.error.feature_support.option_not_supported", "--not-after");
                throw new SOPGPException.UnsupportedOption(errorMsg2, unsupportedOption);
            }
        }
        if (this.notBefore != null) {
            try {
                inlineVerify.notBefore(this.parseNotBefore(this.notBefore));
            }
            catch (SOPGPException.UnsupportedOption unsupportedOption) {
                String errorMsg3 = this.getMsg("sop.error.feature_support.option_not_supported", "--not-before");
                throw new SOPGPException.UnsupportedOption(errorMsg3, unsupportedOption);
            }
        }
        for (String certInput : this.certificates) {
            try {
                InputStream certIn = this.getInput(certInput);
                try {
                    inlineVerify.cert(certIn);
                }
                finally {
                    if (certIn == null) continue;
                    certIn.close();
                }
            }
            catch (IOException ioException) {
                throw new RuntimeException(ioException);
            }
            catch (SOPGPException.UnsupportedAsymmetricAlgo unsupportedAsymmetricAlgo) {
                String errorMsg4 = this.getMsg("sop.error.runtime.cert_uses_unsupported_asymmetric_algorithm", certInput);
                throw new SOPGPException.UnsupportedAsymmetricAlgo(errorMsg4, unsupportedAsymmetricAlgo);
            }
            catch (SOPGPException.BadData badData) {
                String errorMsg5 = this.getMsg("sop.error.input.not_a_certificate", certInput);
                throw new SOPGPException.BadData(errorMsg5, badData);
            }
        }
        List<Verification> verifications = null;
        try {
            ReadyWithResult<List<Verification>> ready = inlineVerify.data(System.in);
            verifications = ready.writeTo(System.out);
        }
        catch (SOPGPException.NoSignature e) {
            errorMsg = this.getMsg("sop.error.runtime.no_verifiable_signature_found");
            throw new SOPGPException.NoSignature(errorMsg, e);
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
        catch (SOPGPException.BadData badData) {
            errorMsg = this.getMsg("sop.error.input.stdin_not_a_message");
            throw new SOPGPException.BadData(errorMsg, badData);
        }
        if (this.verificationsOut != null) {
            try (OutputStream outputStream = this.getOutput(this.verificationsOut);){
                PrintWriter pw = new PrintWriter(outputStream);
                for (Verification verification : verifications) {
                    pw.println(verification);
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

