/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.cli.commands;

import com.ginsberg.junit.exit.FailOnSystemExit;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPKeyRing;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.bouncycastle.openpgp.operator.PBESecretKeyDecryptor;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.pgpainless.PGPainless;
import org.pgpainless.cli.PGPainlessCLI;
import org.pgpainless.cli.TestUtils;
import org.pgpainless.key.info.KeyInfo;
import org.pgpainless.key.info.KeyRingInfo;
import org.pgpainless.key.protection.UnlockSecretKey;
import org.pgpainless.util.Passphrase;

public class GenerateCertCmdTest {
    @Test
    @FailOnSystemExit
    public void testKeyGeneration() throws IOException, PGPException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        System.setOut(new PrintStream(out));
        PGPainlessCLI.execute((String[])new String[]{"generate-key", "--armor", "Juliet Capulet <juliet@capulet.lit>"});
        PGPSecretKeyRing secretKeys = PGPainless.readKeyRing().secretKeyRing(out.toByteArray());
        KeyRingInfo info = PGPainless.inspectKeyRing((PGPKeyRing)secretKeys);
        Assertions.assertTrue((boolean)info.isFullyDecrypted());
        Assertions.assertTrue((boolean)info.isUserIdValid("Juliet Capulet <juliet@capulet.lit>"));
        for (PGPSecretKey key : secretKeys) {
            Assertions.assertTrue((boolean)this.testPassphrase(key, null));
        }
        byte[] outBegin = new byte[37];
        System.arraycopy(out.toByteArray(), 0, outBegin, 0, 37);
        Assertions.assertArrayEquals((byte[])outBegin, (byte[])TestUtils.ARMOR_PRIVATE_KEY_HEADER_BYTES);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @FailOnSystemExit
    public void testGenerateKeyWithPassword() throws IOException, PGPException {
        PrintStream orig = System.out;
        try {
            File tempDir = TestUtils.createTempDirectory();
            File passwordFile = TestUtils.writeTempFile(tempDir, "sw0rdf1sh".getBytes(StandardCharsets.UTF_8));
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            System.setOut(new PrintStream(out));
            PGPainlessCLI.execute((String[])new String[]{"generate-key", "Juliet Capulet <juliet@capulet.lit>", "--with-key-password", passwordFile.getAbsolutePath()});
            PGPSecretKeyRing secretKeys = PGPainless.readKeyRing().secretKeyRing(out.toByteArray());
            KeyRingInfo info = PGPainless.inspectKeyRing((PGPKeyRing)secretKeys);
            Assertions.assertFalse((boolean)info.isFullyDecrypted());
            Assertions.assertTrue((boolean)info.isFullyEncrypted());
            for (PGPSecretKey key : secretKeys) {
                Assertions.assertTrue((boolean)this.testPassphrase(key, "sw0rdf1sh"));
            }
        }
        finally {
            System.setOut(orig);
        }
    }

    private boolean testPassphrase(PGPSecretKey key, String passphrase) throws PGPException {
        if (KeyInfo.isEncrypted((PGPSecretKey)key)) {
            UnlockSecretKey.unlockSecretKey((PGPSecretKey)key, (Passphrase)Passphrase.fromPassword((String)passphrase));
        } else {
            if (passphrase != null) {
                return false;
            }
            UnlockSecretKey.unlockSecretKey((PGPSecretKey)key, (PBESecretKeyDecryptor)null);
        }
        return true;
    }

    @Test
    @FailOnSystemExit
    public void testNoArmor() {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        System.setOut(new PrintStream(out));
        PGPainlessCLI.execute((String[])new String[]{"generate-key", "--no-armor", "Test <test@test.test>"});
        byte[] outBegin = new byte[37];
        System.arraycopy(out.toByteArray(), 0, outBegin, 0, 37);
        Assertions.assertFalse((boolean)Arrays.equals(outBegin, TestUtils.ARMOR_PRIVATE_KEY_HEADER_BYTES));
    }
}

