/*
 * Decompiled with CFR 0.152.
 */
package sop.util;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import sop.exception.SOPGPException;

public class UTF8Util {
    private static final CharsetDecoder UTF8Decoder = Charset.forName("UTF8").newDecoder().onUnmappableCharacter(CodingErrorAction.REPORT).onMalformedInput(CodingErrorAction.REPORT);

    public static String decodeUTF8(byte[] data) {
        ByteBuffer byteBuffer = ByteBuffer.wrap(data);
        try {
            CharBuffer charBuffer = UTF8Decoder.decode(byteBuffer);
            return charBuffer.toString();
        }
        catch (CharacterCodingException e) {
            throw new SOPGPException.PasswordNotHumanReadable();
        }
    }
}

