/*
 * Decompiled with CFR 0.152.
 */
package sop.cli.picocli.commands;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import picocli.CommandLine;
import sop.Verification;
import sop.cli.picocli.Print;
import sop.cli.picocli.SopCLI;
import sop.cli.picocli.commands.AbstractSopCmd;
import sop.exception.SOPGPException;
import sop.operation.DetachedVerify;

@CommandLine.Command(name="verify", resourceBundle="msg_detached-verify", exitCodeOnInvalidInput=37)
public class VerifyCmd
extends AbstractSopCmd {
    @CommandLine.Parameters(index="0", paramLabel="SIGNATURE")
    String signature;
    @CommandLine.Parameters(index="0..*", arity="1..*", paramLabel="CERT")
    List<String> certificates = new ArrayList<String>();
    @CommandLine.Option(names={"--not-before"}, paramLabel="DATE")
    String notBefore = "-";
    @CommandLine.Option(names={"--not-after"}, paramLabel="DATE")
    String notAfter = "now";

    @Override
    public void run() {
        String errorMsg;
        List<Verification> verifications;
        DetachedVerify detachedVerify = this.throwIfUnsupportedSubcommand(SopCLI.getSop().detachedVerify(), "verify");
        if (this.notAfter != null) {
            try {
                detachedVerify.notAfter(this.parseNotAfter(this.notAfter));
            }
            catch (SOPGPException.UnsupportedOption unsupportedOption) {
                String errorMsg2 = this.getMsg("sop.error.feature_support.option_not_supported", "--not-after");
                throw new SOPGPException.UnsupportedOption(errorMsg2, unsupportedOption);
            }
        }
        if (this.notBefore != null) {
            try {
                detachedVerify.notBefore(this.parseNotBefore(this.notBefore));
            }
            catch (SOPGPException.UnsupportedOption unsupportedOption) {
                String errorMsg3 = this.getMsg("sop.error.feature_support.option_not_supported", "--not-before");
                throw new SOPGPException.UnsupportedOption(errorMsg3, unsupportedOption);
            }
        }
        for (String certInput : this.certificates) {
            try {
                InputStream certIn = this.getInput(certInput);
                try {
                    detachedVerify.cert(certIn);
                }
                finally {
                    if (certIn == null) continue;
                    certIn.close();
                }
            }
            catch (IOException ioException) {
                throw new RuntimeException(ioException);
            }
            catch (SOPGPException.BadData badData) {
                String errorMsg4 = this.getMsg("sop.error.input.not_a_certificate", certInput);
                throw new SOPGPException.BadData(errorMsg4, badData);
            }
        }
        if (this.signature != null) {
            try (InputStream sigIn = this.getInput(this.signature);){
                detachedVerify.signatures(sigIn);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            catch (SOPGPException.BadData badData) {
                String errorMsg5 = this.getMsg("sop.error.input.not_a_signature", this.signature);
                throw new SOPGPException.BadData(errorMsg5, badData);
            }
        }
        try {
            verifications = detachedVerify.data(System.in);
        }
        catch (SOPGPException.NoSignature e) {
            errorMsg = this.getMsg("sop.error.runtime.no_verifiable_signature_found");
            throw new SOPGPException.NoSignature(errorMsg, e);
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
        catch (SOPGPException.BadData badData) {
            errorMsg = this.getMsg("sop.error.input.stdin_not_a_message");
            throw new SOPGPException.BadData(errorMsg, badData);
        }
        for (Verification verification : verifications) {
            Print.outln(verification.toString());
        }
    }
}

