/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.bcpg;

import java.io.IOException;
import org.bouncycastle.bcpg.AEADAlgorithmTags;
import org.bouncycastle.bcpg.BCPGInputStream;
import org.bouncycastle.bcpg.InputStreamPacket;
import org.bouncycastle.util.Arrays;

public class AEADEncDataPacket
extends InputStreamPacket
implements AEADAlgorithmTags {
    private final byte version;
    private final byte algorithm;
    private final byte aeadAlgorithm;
    private final byte chunkSize;
    private final byte[] iv;

    public AEADEncDataPacket(BCPGInputStream bCPGInputStream) throws IOException {
        super(bCPGInputStream);
        this.version = (byte)bCPGInputStream.read();
        if (this.version != 1) {
            throw new IllegalArgumentException("wrong AEAD packet version: " + this.version);
        }
        this.algorithm = (byte)bCPGInputStream.read();
        this.aeadAlgorithm = (byte)bCPGInputStream.read();
        this.chunkSize = (byte)bCPGInputStream.read();
        this.iv = new byte[AEADEncDataPacket.getIVLength(this.aeadAlgorithm)];
        bCPGInputStream.read(this.iv, 0, this.iv.length);
    }

    public AEADEncDataPacket(int n, int n2, int n3, byte[] byArray) {
        super(null);
        this.version = 1;
        this.algorithm = (byte)n;
        this.aeadAlgorithm = (byte)n2;
        this.chunkSize = (byte)n3;
        this.iv = Arrays.clone(byArray);
    }

    public byte getVersion() {
        return this.version;
    }

    public byte getAlgorithm() {
        return this.algorithm;
    }

    public byte getAEADAlgorithm() {
        return this.aeadAlgorithm;
    }

    public int getChunkSize() {
        return this.chunkSize;
    }

    public byte[] getIV() {
        return this.iv;
    }

    public static int getIVLength(byte by) {
        switch (by) {
            case 1: {
                return 16;
            }
            case 2: {
                return 15;
            }
            case 3: {
                return 12;
            }
        }
        throw new IllegalArgumentException("unknown mode: " + by);
    }
}

